/*
 * Decompiled with CFR 0.152.
 */
package io.imqa.asm;

import io.imqa.asm.EventVisitor;
import io.imqa.asm.Finder;
import io.imqa.injector.util.Logger;
import java.util.ArrayList;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class EventFinder
implements Finder {
    @Override
    public void init() {
    }

    @Override
    public boolean find(String name) {
        switch (name) {
            case "android/view/View$OnClickListener": 
            case "android/view/View$OnLongClickListener": 
            case "android/view/View$OnFocusChangeListener": 
            case "android/view/View$OnKeyListener": 
            case "android/view/View$OnTouchListener": {
                return true;
            }
        }
        return false;
    }

    private boolean checkMethod(String name, String[] allowedNameList) {
        for (String allowedName : allowedNameList) {
            if (!name.equals(allowedName)) continue;
            return true;
        }
        return false;
    }

    private String[] getEventMethod(String eventName) {
        ArrayList<String> methodList = new ArrayList<String>();
        switch (eventName) {
            case "android/view/View$OnClickListener": {
                methodList.add("onClick");
                break;
            }
            case "android/view/View$OnLongClickListener": {
                methodList.add("onLongClick");
                break;
            }
            case "android/view/View$OnFocusChangeListener": {
                methodList.add("onFocusChange");
                break;
            }
            case "android/view/View$OnKeyListener": {
                methodList.add("onKey");
                break;
            }
            case "android/view/View$OnTouchListener": {
                methodList.add("onTouch");
            }
        }
        String[] methodArray = new String[methodList.size()];
        methodList.toArray(methodArray);
        return methodArray;
    }

    @Override
    public MethodVisitor getVisitor(String[] interfaceList, String className, String superName, int access, String name, String desc, MethodVisitor mv) {
        if (this.find(superName) && this.checkMethod(name, this.getEventMethod(superName))) {
            return new EventVisitor(className, access, name, desc, mv);
        }
        for (String interfaceName : interfaceList) {
            if (!this.find(interfaceName) || !this.checkMethod(name, this.getEventMethod(interfaceName))) continue;
            Logger.d("Event Inject", className + ", Method : " + name);
            return new EventVisitor(className, access, name, desc, mv);
        }
        return mv;
    }

    @Override
    public void visitEnd(ClassVisitor cv, String className, String superClass, String[] interfaceList) {
    }
}

