/*
 * Decompiled with CFR 0.152.
 */
package io.imqa.asm;

import io.imqa.asm.Finder;
import io.imqa.asm.FragmentMakerVisitor;
import io.imqa.asm.FragmentVisitor;
import io.imqa.injector.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class FragmentMakerFinder
implements Finder {
    HashMap<String, Boolean> lifeCycle = new HashMap();

    @Override
    public void init() {
        this.lifeCycle.clear();
        this.lifeCycle.put("onCreate", false);
        this.lifeCycle.put("onCreateView", false);
        this.lifeCycle.put("onStart", false);
        this.lifeCycle.put("onResume", false);
    }

    @Override
    public boolean find(String name) {
        switch (name) {
            case "android/support/v4/app/Fragment": 
            case "android/support/v4/app/DialogFragment": 
            case "android/support/v4/app/ListFragment": 
            case "android/support/v4/app/PreferenceFragment": 
            case "android/app/Fragment": {
                Logger.d("SuperClass name", name);
                return true;
            }
        }
        return false;
    }

    private boolean checkMethod(String name, String[] allowedNameList) {
        for (String allowedName : allowedNameList) {
            if (!name.equals(allowedName)) continue;
            return true;
        }
        return false;
    }

    private String[] getFragmentMethod() {
        ArrayList<String> methodList = new ArrayList<String>();
        methodList.add("onCreate");
        methodList.add("onCreateView");
        methodList.add("onActivityCreated");
        methodList.add("onViewStateRestored");
        methodList.add("onStart");
        methodList.add("onResume");
        String[] methodArray = new String[methodList.size()];
        methodList.toArray(methodArray);
        return methodArray;
    }

    @Override
    public MethodVisitor getVisitor(String[] interfaceList, String className, String superName, int access, String name, String desc, MethodVisitor mv) {
        if (this.find(superName) && this.checkMethod(name, this.getFragmentMethod())) {
            Logger.d("Fragment Inject", className + ", Method : " + name);
            this.setVisited(name);
            return new FragmentVisitor(className, access, name, desc, mv);
        }
        for (String interfaceName : interfaceList) {
            if (!this.find(interfaceName) || !this.checkMethod(name, this.getFragmentMethod())) continue;
            Logger.d("Fragment Inject", className + ", Method : " + name);
            this.setVisited(name);
            return new FragmentVisitor(className, access, name, desc, mv);
        }
        return mv;
    }

    @Override
    public void visitEnd(ClassVisitor cv, String className, String superClass, String[] interfaceList) {
        if (this.find(superClass)) {
            this.makeVisit(cv, className, superClass);
        }
        for (String interfaceName : interfaceList) {
            if (!this.find(interfaceName)) continue;
            this.makeVisit(cv, className, superClass);
        }
    }

    protected void setVisited(String name) {
        switch (name) {
            case "onCreate": 
            case "onCreateView": 
            case "onStart": 
            case "onResume": {
                this.lifeCycle.replace(name, true);
            }
        }
    }

    protected void makeVisit(ClassVisitor cv, String className, String superClass) {
        Set<String> cycleNames = this.lifeCycle.keySet();
        for (String cycleName : cycleNames) {
            if (this.lifeCycle.get(cycleName).booleanValue()) continue;
            String desc = "()V";
            switch (cycleName) {
                case "onCreate": {
                    desc = "(Landroid/os/Bundle;)V";
                    break;
                }
                case "onCreateView": {
                    desc = "(Landroid/view/LayoutInflater;Landroid/view/ViewGroup;Landroid/os/Bundle;)Landroid/view/View;";
                }
            }
            MethodVisitor mv = cv.visitMethod(1, cycleName, desc, null, null);
            FragmentMakerVisitor lifecyclemv = new FragmentMakerVisitor(className, 1, cycleName, superClass, desc, mv);
            lifecyclemv.visitCode();
            lifecyclemv.visitInsn(177);
        }
    }
}

