/*
 * Decompiled with CFR 0.152.
 */
package io.imqa.asm;

import io.imqa.asm.EventFinder;
import io.imqa.asm.Finder;
import io.imqa.asm.FragmentMakerFinder;
import io.imqa.asm.WebviewFinder;
import io.imqa.injector.util.BuildOption;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class GlobalClassVisitor
extends ClassVisitor {
    String superClass = "";
    String className = "";
    boolean eventClass = false;
    boolean webviewClass = false;
    String[] interfaces;
    List<Finder> finderList = new ArrayList<Finder>();

    public GlobalClassVisitor(ClassVisitor cv) {
        super(327680, cv);
        if (BuildOption.eventListenerInject) {
            this.finderList.add(new EventFinder());
        }
        if (BuildOption.webViewInject) {
            this.finderList.add(new WebviewFinder());
        }
        if (BuildOption.fragmentInject) {
            this.finderList.add(new FragmentMakerFinder());
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.cv.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
        this.superClass = superName;
        this.interfaces = interfaces;
        for (Finder finder : this.finderList) {
            if (!finder.find(superName)) continue;
            finder.init();
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        for (Finder finder : this.finderList) {
            mv = finder.getVisitor(this.interfaces, this.className, this.superClass, access, name, desc, mv);
        }
        return mv;
    }

    public void visitEnd() {
        for (Finder finder : this.finderList) {
            finder.visitEnd(this.cv, this.className, this.superClass, this.interfaces);
        }
        this.cv.visitEnd();
    }
}

