/*
 * Decompiled with CFR 0.152.
 */
package io.imqa.injector;

import java.io.File;

public class AndroidBuildConfig {
    private String projectName = "";
    private String flavor = "";
    private String buildType = "";
    private String packageName = "";
    private String applicationId = "";

    public AndroidBuildConfig(String projectName, String flavor, String buildType) {
        this.projectName = projectName;
        this.buildType = buildType;
        this.flavor = flavor;
        this.init();
    }

    private void init() {
        String buildConfigLocation = this.projectName + "/build/generated/source/buildConfig/";
        if (!this.flavor.equals("")) {
            buildConfigLocation = buildConfigLocation + this.flavor + "/";
        }
        buildConfigLocation = buildConfigLocation + this.buildType + "/";
        File configDir = new File(buildConfigLocation);
        this.packageName = this.findBuildConfig(configDir);
        this.packageName = this.packageName.substring(0, this.packageName.indexOf(".BuildConfig.java"));
    }

    private String findBuildConfig(File target) {
        String packageName = "";
        for (File item : target.listFiles()) {
            packageName = packageName + item.getName();
            if (!item.isDirectory()) continue;
            packageName = packageName + "." + this.findBuildConfig(item);
            return packageName;
        }
        return packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }
}

