/*
 * Decompiled with CFR 0.152.
 */
package io.imqa.injector;

import io.imqa.injector.util.Logger;
import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidManifestParser {
    private String manifestLocation;
    private ArrayList<String> activityList = new ArrayList();
    private String projectName = "";
    private String flavor = "";
    private String buildType = "";
    private String packageName = "";
    private String sourceSet = "";

    public AndroidManifestParser(String projectName, String flavor, String buildType, String packageName) {
        this.projectName = projectName;
        this.buildType = buildType;
        this.flavor = flavor;
        this.packageName = packageName;
        this.manifestLocation = this.findManifestLocation(projectName + "/build/intermediates/manifests/full/");
        this.activityList = this.findActivityList(this.manifestLocation);
    }

    public ArrayList<String> getActivityList() {
        return this.activityList;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSourceSet() {
        return this.sourceSet;
    }

    private String findManifestLocation(String fileName) {
        if (!this.flavor.equals("")) {
            fileName = fileName + this.flavor + "/";
        }
        fileName = fileName + this.buildType + "/AndroidManifest.xml";
        Logger.d("Manifest Location", fileName);
        return fileName;
    }

    private ArrayList<String> findActivityList(String fileName) {
        ArrayList<String> activityList = new ArrayList<String>();
        NodeList nodeList = null;
        try {
            File fXmlFile = new File(fileName);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            String beforePackageName = doc.getDocumentElement().getAttribute("package");
            this.sourceSet = beforePackageName = beforePackageName.replace(".", "/");
            Logger.d("Root element", doc.getDocumentElement().getNodeName());
            NodeList applicationList = doc.getElementsByTagName("application");
            nodeList = applicationList.item(0).getChildNodes();
            Logger.d("-----------------------");
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Element eElement;
                String activityName;
                Node nNode = nodeList.item(index);
                if (nNode.getNodeType() != 1 || !nNode.getNodeName().equals("activity") || (activityName = this.findActivityName(eElement = (Element)nNode)) == null) continue;
                activityName = activityName.replace(".", "/");
                Logger.d("Activity name", activityName);
                activityList.add(activityName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return activityList;
    }

    private String findActivityName(Element eElement) {
        String sTag = "android:name";
        String enabled = "android:enabled";
        if (eElement.getAttribute(enabled).equals("false")) {
            return null;
        }
        return eElement.getAttribute(sTag);
    }

    public static boolean checkActivityManifest(String fileName, String targetPackageName) {
        try {
            File fXmlFile = new File(fileName);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            String libPackageName = doc.getDocumentElement().getAttribute("package");
            libPackageName = libPackageName.replace(".", "/");
            Logger.d("Check library manifest", targetPackageName + " / " + libPackageName);
            return targetPackageName.equals(libPackageName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

