/*
 * Decompiled with CFR 0.152.
 */
package io.imqa.injector;

import io.imqa.injector.util.BuildOption;
import io.imqa.injector.util.Logger;
import java.util.HashSet;
import java.util.Iterator;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;

public class DependencyInjector {
    public static final String CONF_IMQA_SDK = "imqa";
    DependencySet compileDeps;
    private static final String IMQA_GROUP_NAME = "io.imqa";
    private static final String MPM_SDK_NAME = "imqa-mpm-client";
    private static final String CRASH_SDK_NAME = "imqa-crash-client";
    private String MPM_SDK_INFO_FOR_DEPENDENCY = this.MPM_SDK_INFO_FOR_DEPENDENCY + "io.imqa:imqa-mpm-client:1.2.7";
    private String CRASH_SDK_INFO_FOR_DEPENDENCY = this.CRASH_SDK_INFO_FOR_DEPENDENCY + "io.imqa:imqa-crash-client:1.2.2";

    public void doInject(Project project) {
        Logger.d("Version Ready", this.MPM_SDK_INFO_FOR_DEPENDENCY);
        Logger.d("Version Ready", this.CRASH_SDK_INFO_FOR_DEPENDENCY);
        HashSet<String> dependencyTypeSet = new HashSet<String>();
        dependencyTypeSet.add("compile");
        for (Configuration conf : project.getRootProject().getBuildscript().getConfigurations()) {
            DependencySet depIts = conf.getAllDependencies();
            for (Dependency dep : depIts) {
                if (!dep.getGroup().equals("com.android.tools.build") || !dep.getName().equals("gradle")) continue;
                String version = new String(dep.getVersion());
                Logger.d("Version", version);
                try {
                    String[] splitedVersion = version.split("\\.");
                    int majorVersion = Integer.parseInt(splitedVersion[0]);
                    int minorVersion = Integer.parseInt(splitedVersion[1]);
                    int microVersion = Integer.parseInt(splitedVersion[2]);
                    if (majorVersion != 3) continue;
                    if (minorVersion >= 1) {
                        dependencyTypeSet.clear();
                    }
                    dependencyTypeSet.add("implementation");
                }
                catch (Exception e) {
                    Logger.d("IMQA ERROR", e.getMessage());
                }
            }
        }
        String dependencyType = "";
        boolean hasMpmDependency = false;
        boolean hasCrashDependency = false;
        Iterator depIter = dependencyTypeSet.iterator();
        while (depIter.hasNext()) {
            dependencyType = String.valueOf(depIter.next());
            Logger.d("Dependency Type", dependencyType);
            this.compileDeps = project.getConfigurations().getByName(dependencyType).getDependencies();
            if (DependencyInjector.hasDependency(this.compileDeps, MPM_SDK_NAME)) {
                hasMpmDependency = true;
            }
            if (!DependencyInjector.hasDependency(this.compileDeps, CRASH_SDK_NAME)) continue;
            hasCrashDependency = true;
        }
        if (!hasMpmDependency && BuildOption.imqaMpm) {
            DependencyInjector.dynamicDependencyInject(project, dependencyType, this.MPM_SDK_INFO_FOR_DEPENDENCY);
        }
        if (!hasCrashDependency && BuildOption.imqaCrash) {
            DependencyInjector.dynamicDependencyInject(project, dependencyType, this.CRASH_SDK_INFO_FOR_DEPENDENCY);
        }
    }

    private static boolean hasDependency(DependencySet compileDeps, String imqaDependency) {
        boolean hasDependency = false;
        for (Dependency dep : compileDeps) {
            if (dep.getGroup() == null || !dep.getGroup().equals(IMQA_GROUP_NAME) || !dep.getName().equals(imqaDependency)) continue;
            hasDependency = true;
        }
        return hasDependency;
    }

    private static void dynamicDependencyInject(Project project, String dependencyType, String name) {
        project.getConfigurations().getByName(dependencyType).getDependencies().add((Object)project.getDependencies().create((Object)name));
        Logger.d("SDK Imported", name);
    }
}

