/*
 * Decompiled with CFR 0.152.
 */
package io.imqa.injector;

import io.imqa.injector.util.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;

public class JarUtil {
    private Manifest jarManifest;

    public String jarExtracting(String source) throws IOException, FileNotFoundException {
        String destDir = source.substring(0, source.lastIndexOf("/")) + "/temp";
        File tempDir = new File(destDir);
        if (!tempDir.exists()) {
            tempDir.mkdir();
        }
        JarFile jar = new JarFile(source);
        this.jarManifest = jar.getManifest();
        Enumeration<JarEntry> enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry file = enumEntries.nextElement();
            File f = new File(destDir + "/" + file.getName());
            if (file.isDirectory()) {
                f.mkdir();
                continue;
            }
            InputStream is = jar.getInputStream(file);
            FileOutputStream fos = new FileOutputStream(f);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
        jar.close();
        return destDir + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jarReCompressing(String source, String target) throws IOException, FileNotFoundException {
        Logger.d(source);
        try (ZipOutputStream jos = null;){
            jos = new JarOutputStream((OutputStream)new FileOutputStream(target), this.jarManifest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jarAdd(File source, JarOutputStream target) throws IOException, FileNotFoundException {
        try (BufferedInputStream in = null;){
            int count;
            if (source.isDirectory()) {
                String name = source.getCanonicalPath().replace("\\", "/");
                if (!name.isEmpty()) {
                    if (!name.endsWith("/")) {
                        name = name + "/";
                    }
                    JarEntry entry = new JarEntry(this.cutDirectoryPath(name));
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                for (File nestedFile : source.listFiles()) {
                    this.jarAdd(nestedFile, target);
                }
                return;
            }
            if (source.getName().equals("classes.jar")) {
                return;
            }
            if (source.getName().equals("MANIFEST.MF")) {
                return;
            }
            JarEntry entry = new JarEntry(this.cutDirectoryPath(source.getCanonicalPath().replace("\\", "/")));
            target.putNextEntry(entry);
            in = new BufferedInputStream(new FileInputStream(source));
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
    }

    public String cutDirectoryPath(String origin) {
        String result = "";
        if (origin.length() > 0) {
            Logger.d("Cut Detecting", "Origin: " + origin);
            String sourceDirName = "/temp";
            Logger.d("Cut Detecting", "origin Length: " + origin.length());
            Logger.d("Cut Detecting", "sourceDirName Length: " + sourceDirName.length());
            int startIndex = origin.indexOf(sourceDirName) + sourceDirName.length();
            int length = origin.length() - startIndex;
            Logger.d("Cut Detecting", "Data: " + startIndex + ", " + length);
            result = length > 0 ? origin.substring(startIndex + 1) : origin.substring(startIndex);
            Logger.d("Cut Detecting", "After: " + result);
        }
        return result;
    }

    public void deleteFolder(String parentPath) {
        File file = new File(parentPath);
        String[] fnameList = file.list();
        int fCnt = fnameList.length;
        String childPath = "";
        for (int i = 0; i < fCnt; ++i) {
            childPath = parentPath + "/" + fnameList[i];
            File f = new File(childPath);
            if (!f.isDirectory()) {
                f.delete();
                continue;
            }
            this.deleteFolder(childPath);
        }
        File f = new File(parentPath);
        f.delete();
    }
}

