/*
 * Decompiled with CFR 0.152.
 */
package io.imqa.injector;

import io.imqa.injector.AndroidBuildConfig;
import io.imqa.injector.AndroidManifestParser;
import io.imqa.injector.DependencyInjector;
import io.imqa.injector.GlobalInjector;
import io.imqa.injector.InjectorException;
import io.imqa.injector.ProjectActivityInjector;
import io.imqa.injector.util.BuildOption;
import io.imqa.injector.util.Logger;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.plugins.DefaultExtraPropertiesExtension;
import org.gradle.api.tasks.TaskContainer;

public class JavacAction
implements Action<Project> {
    private static String projectName = "";
    private static ArrayList<String> buildTypeList = new ArrayList();

    public JavacAction(String projectName) {
        JavacAction.projectName = projectName;
    }

    public void execute(Project project) {
        Logger.d("After Evaluate!!!");
        try {
            Object androidProps = project.property("android");
            Class<?> androidPropsClazz = Class.forName(androidProps.getClass().getName());
            Logger.d("TEST 1", androidProps.getClass().getName());
            Method androidPropsMethod = androidPropsClazz.getMethod("getBuildTypes", new Class[0]);
            androidPropsMethod.setAccessible(true);
            NamedDomainObjectContainer buildTypeContainer = (NamedDomainObjectContainer)androidPropsMethod.invoke(androidProps, new Object[0]);
            for (Object buildType : buildTypeContainer) {
                Class<?> buildTypeClazz = Class.forName(buildType.getClass().getName());
                Logger.d("TEST 2", buildType.getClass().getName());
                Method buildTypeMethod = buildTypeClazz.getMethod("getName", new Class[0]);
                buildTypeMethod.setAccessible(true);
                buildTypeList.add((String)buildTypeMethod.invoke(buildType, new Object[0]));
                Logger.d("All BuildTypes", (String)buildTypeMethod.invoke(buildType, new Object[0]));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DefaultExtraPropertiesExtension property = (DefaultExtraPropertiesExtension)project.property("ext");
        Map properties = property.getProperties();
        if (!properties.isEmpty()) {
            Set keys = properties.keySet();
            for (Object buildIt : keys) {
            }
        }
        if (property.has("IMQALifecycle")) {
            BuildOption.lifecycleInject = (Boolean)property.getProperty("IMQALifecycle");
        }
        if (property.has("IMQAEventListener")) {
            BuildOption.eventListenerInject = (Boolean)property.getProperty("IMQAEventListener");
        }
        if (property.has("IMQALibraryActivity")) {
            BuildOption.libraryActivityInject = (Boolean)property.getProperty("IMQALibraryActivity");
        }
        if (property.has("IMQAFragment")) {
            BuildOption.fragmentInject = (Boolean)property.getProperty("IMQAFragment");
        }
        if (property.has("IMQAWebview")) {
            BuildOption.webViewInject = (Boolean)property.getProperty("IMQAWebview");
        }
        if (property.has("IMQAMPM")) {
            BuildOption.imqaMpm = (Boolean)property.getProperty("IMQAMPM");
        }
        if (property.has("IMQACrash")) {
            BuildOption.imqaCrash = (Boolean)property.getProperty("IMQACrash");
        }
        DependencyInjector depInjector = new DependencyInjector();
        depInjector.doInject(project);
        TaskContainer tc = project.getTasks();
        Logger.d("Task Container", tc.toString());
        for (Task compileTask : tc) {
            Pattern javacPattern = Pattern.compile(":" + projectName + ":compile(\\w*)(Release|Debug)JavaWithJavac");
            String nonFalvorPatter = ":" + projectName + ":compile(Release|Debug)JavaWithJavac";
            if (buildTypeList.size() > 0) {
                for (String buildTypeStr : buildTypeList) {
                    javacPattern = Pattern.compile(":" + projectName + ":compile(\\w+)" + this.toCapitalize(buildTypeStr) + "JavaWithJavac");
                    Matcher javacMatcher = javacPattern.matcher(compileTask.toString());
                    javacPattern = Pattern.compile(":" + projectName + ":compile" + this.toCapitalize(buildTypeStr) + "JavaWithJavac");
                    Matcher nonFlavorJavacMatcher = javacPattern.matcher(compileTask.toString());
                    if (javacMatcher.find()) {
                        this.findBuildType(compileTask, buildTypeStr);
                        Logger.d("Pattern", javacPattern.toString());
                        continue;
                    }
                    if (!nonFlavorJavacMatcher.find()) continue;
                    this.findBuildType(compileTask, buildTypeStr);
                    Logger.d("Pattern", javacPattern.toString());
                }
                continue;
            }
            Matcher javacMatcher = javacPattern.matcher(compileTask.toString());
            javacPattern = Pattern.compile(":" + projectName + ":compile(Release|Debug)JavaWithJavac");
            Matcher nonFlavorJavacMatcher = javacPattern.matcher(compileTask.toString());
            if (javacMatcher.find()) {
                this.findBuildType(compileTask, javacMatcher.group(1).toLowerCase());
                Logger.d("Pattern", javacPattern.toString());
                continue;
            }
            if (!nonFlavorJavacMatcher.find()) continue;
            this.findBuildType(compileTask, javacMatcher.group(1).toLowerCase());
            Logger.d("Pattern", javacPattern.toString());
        }
    }

    private void findBuildType(Task compileTask, final String buildType) {
        Logger.d("Task Name: " + compileTask.getName() + ", Task Desc: " + compileTask.getDescription());
        compileTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Logger.d("Task Name: " + task.getName() + ", Task Desc: " + task.getDescription());
                String flavor = "";
                Pattern flavorPattern = Pattern.compile(":" + projectName + ":compile(\\w+)(" + JavacAction.this.toCapitalize(buildType) + ")JavaWithJavac");
                Matcher flavorMatcher = flavorPattern.matcher(task.toString());
                if (flavorMatcher.find()) {
                    flavor = flavorMatcher.group(1).toLowerCase();
                }
                String buildLocation = projectName + "/build/intermediates/classes/";
                if (!flavor.equals("")) {
                    buildLocation = buildLocation + flavor + "/";
                }
                buildLocation = buildLocation + buildType + "/";
                AndroidBuildConfig buildConfig = new AndroidBuildConfig(projectName, flavor, buildType);
                AndroidManifestParser androidManifestParser = new AndroidManifestParser(projectName, flavor, buildType, buildConfig.getPackageName());
                ArrayList<String> activityList = androidManifestParser.getActivityList();
                Logger.d("LifeCycle Search", "Start");
                int injectedFileCount = 0;
                for (String activityName : activityList) {
                    ++injectedFileCount;
                    JavacAction.this.callLifeCycleInject(buildConfig.getPackageName().replace(".", "/"), activityName, buildLocation);
                }
                Logger.d("LifeCycle Search", "LifeCycle Searched of " + injectedFileCount + " Files");
                ArrayList fileList = JavacAction.this.getAllFileList(new File(buildLocation));
                Logger.d("Global Search", "Start");
                injectedFileCount = 0;
                for (String fileAbsolteName : fileList) {
                    ++injectedFileCount;
                    JavacAction.this.callGlobalInject(fileAbsolteName);
                }
                Logger.d("Global Search", "Global Searched of " + injectedFileCount + " Files");
            }
        });
    }

    private ArrayList<String> getAllFileList(File root) {
        File[] files;
        ArrayList<String> list = new ArrayList<String>();
        for (File file : files = root.listFiles()) {
            if (file.isFile()) {
                String[] names = file.getName().split("\\.");
                if (names.length <= 0 || !names[names.length - 1].equals("class")) continue;
                list.add(file.getAbsolutePath());
                continue;
            }
            list.addAll(this.getAllFileList(file));
        }
        return list;
    }

    private void callLifeCycleInject(String packageName, String activityName, String buildLocation) {
        if (BuildOption.lifecycleInject) {
            try {
                ProjectActivityInjector activityInjector = new ProjectActivityInjector(projectName, packageName, activityName, buildLocation);
                if (activityInjector == null) {
                    throw new InjectorException();
                }
                activityInjector.doInject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void callGlobalInject(String fileAbsolteName) {
        String[] filePath = fileAbsolteName.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filePath.length - 1; ++i) {
            if (filePath[i].length() <= 0) continue;
            sb.append("/");
            sb.append(filePath[i]);
        }
        GlobalInjector globalInjector = new GlobalInjector(filePath[filePath.length - 1], sb.toString());
        globalInjector.doInject();
    }

    private String toCapitalize(String input) {
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }
}

