/*
 * Decompiled with CFR 0.152.
 */
package io.imqa.injector;

import io.imqa.asm.ActivityTransformer;
import io.imqa.injector.AndroidManifestParser;
import io.imqa.injector.BaseActivityInjector;
import io.imqa.injector.JarUtil;
import io.imqa.injector.util.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class LibraryActivityInjector
extends BaseActivityInjector {
    private String jarLocation;
    private JarUtil jarUtil = new JarUtil();

    public LibraryActivityInjector(String projectName, String packageName, String activityName, String buildLocation) {
        super(projectName, packageName, activityName, buildLocation);
    }

    @Override
    protected void beforeInject() {
        String targetPackageName = this.targetClass.substring(0, this.targetClass.lastIndexOf("/"));
        String jarDir = this.projectName + "/build/intermediates/exploded-aar";
        int dirStep = 0;
        String manifestLocation = this.findLibManifest(jarDir, dirStep, targetPackageName);
        Logger.d("Manifest Location", manifestLocation);
        manifestLocation = manifestLocation.substring(0, manifestLocation.lastIndexOf("/"));
        Logger.d("Library Location : " + manifestLocation);
        this.buildLocation = manifestLocation + "/jars/";
        try {
            this.jarLocation = this.jarUtil.jarExtracting(this.buildLocation + "classes.jar");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.targetClass = this.jarLocation + this.targetClass + ".class";
    }

    @Override
    protected void inject() {
        Logger.d("Bulid Location : " + this.targetClass);
        File classFile = new File(this.buildLocation + "/" + this.targetClass);
        ActivityTransformer.doTransform(classFile);
    }

    @Override
    protected void afterInject() {
        try {
            this.jarUtil.jarReCompressing(this.jarLocation, this.buildLocation + "classes.jar");
            this.jarUtil.deleteFolder(this.jarLocation);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String findLibManifest(String source, int dirStep, String targetPackageName) {
        File dir = new File(source);
        Logger.d("Is Directory : " + dir.isDirectory());
        File[] fileList = dir.listFiles();
        boolean isFileFound = false;
        String libManifest = "";
        Logger.d("FindLibManifest : " + source + "/" + dirStep);
        if (dirStep < 4 && fileList != null) {
            try {
                for (File file : fileList) {
                    Logger.d("FileName : " + file.getName());
                    if (file.isFile()) {
                        if (!file.getName().equals("AndroidManifest.xml")) continue;
                        Logger.d("\ud30c\uc77c \uc774\ub984 = " + file.getName());
                        isFileFound = AndroidManifestParser.checkActivityManifest(file.getCanonicalPath(), targetPackageName);
                        if (!isFileFound) continue;
                        return file.getCanonicalPath();
                    }
                    if (!file.isDirectory() || (libManifest = this.findLibManifest(file.getCanonicalPath(), dirStep + 1, targetPackageName)).equals("")) continue;
                    return libManifest;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return libManifest;
        }
        return libManifest;
    }
}

