/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.furms.rest.workshop;

import io.imunity.furms.domain.authz.roles.Role;
import io.imunity.furms.domain.communities.Community;
import io.imunity.furms.domain.communities.CommunityGroup;
import io.imunity.furms.domain.community_allocation.CommunityAllocation;
import io.imunity.furms.domain.images.FurmsImage;
import io.imunity.furms.domain.resource_credits.ResourceCredit;
import io.imunity.furms.domain.resource_credits.ResourceCreditCreatedEvent;
import io.imunity.furms.domain.sites.Site;
import io.imunity.furms.domain.sites.SiteExternalId;
import io.imunity.furms.domain.users.FURMSUser;
import io.imunity.furms.domain.users.PersistentId;
import io.imunity.furms.rest.workshop.WorkshopService;
import io.imunity.furms.site.api.site_agent.SiteAgentService;
import io.imunity.furms.spi.communites.CommunityGroupsDAO;
import io.imunity.furms.spi.communites.CommunityRepository;
import io.imunity.furms.spi.community_allocation.CommunityAllocationRepository;
import io.imunity.furms.spi.resource_credits.ResourceCreditRepository;
import io.imunity.furms.spi.sites.SiteGroupDAO;
import io.imunity.furms.spi.sites.SiteRepository;
import io.imunity.furms.spi.users.UsersDAO;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Profile(value={"workshop"})
class WorkshopService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String ACTIVATION_PROFILE_NAME = "workshop";
    private final CommunityRepository communityRepository;
    private final CommunityGroupsDAO communityGroupsDAO;
    private final SiteRepository siteRepository;
    private final SiteGroupDAO siteGroupDAO;
    private final UsersDAO usersDAO;
    private final ResourceCreditRepository resourceCreditRepository;
    private final CommunityAllocationRepository communityAllocationRepository;
    private final SiteAgentService siteAgentService;

    WorkshopService(CommunityRepository communityRepository, CommunityGroupsDAO communityGroupsDAO, SiteRepository siteRepository, SiteGroupDAO siteGroupDAO, UsersDAO usersDAO, ResourceCreditRepository resourceCreditRepository, CommunityAllocationRepository communityAllocationRepository, SiteAgentService siteAgentService) {
        this.communityRepository = communityRepository;
        this.communityGroupsDAO = communityGroupsDAO;
        this.siteRepository = siteRepository;
        this.siteGroupDAO = siteGroupDAO;
        this.usersDAO = usersDAO;
        this.resourceCreditRepository = resourceCreditRepository;
        this.communityAllocationRepository = communityAllocationRepository;
        this.siteAgentService = siteAgentService;
    }

    @Async
    @EventListener
    void distributeToMateCommunity(ResourceCreditCreatedEvent event) {
        LOG.info("Received credit allocation event {}", (Object)event);
        Optional credit = this.resourceCreditRepository.findById(event.resourceCredit.id);
        credit.ifPresent(rc -> this.getCorrespondingCommunityId(rc, event.originator).ifPresent(community -> {
            LOG.info("Making community allocation from {} to {}", rc, community);
            CommunityAllocation communityAllocation = CommunityAllocation.builder().communityId(community.getId()).resourceCreditId(rc.id).name("Allocation " + ExternalIdGenerator.generate(id -> true)).amount(rc.amount).build();
            this.communityAllocationRepository.create(communityAllocation);
        }));
    }

    private Optional<Community> getCorrespondingCommunityId(ResourceCredit rc, PersistentId originator) {
        Optional site = this.siteRepository.findById(rc.siteId);
        String key = ((Site)site.get()).getExternalId().id;
        Set communities = this.communityRepository.findAll();
        Optional<Community> community = communities.stream().filter(c -> c.getName().contains(key)).findAny();
        Optional user = this.usersDAO.findById(originator);
        if (user.isEmpty() || ((FURMSUser)user.get()).fenixUserId.isEmpty()) {
            LOG.info("No corresponding community for user w/o fenix id");
            return Optional.empty();
        }
        if (community.isEmpty()) {
            LOG.info("Community name has been changed, using different heuristic basing on {}", (Object)originator);
            for (Community c2 : communities) {
                boolean isOriginatorAdmin = this.communityGroupsDAO.getAllAdmins(c2.getId()).stream().map(u -> u.id).filter(Optional::isPresent).map(Optional::get).anyMatch(id -> id.equals((Object)originator));
                if (!isOriginatorAdmin) continue;
                community = Optional.of(c2);
                break;
            }
        }
        return community;
    }

    void equipUsers() {
        Set allSites = this.siteRepository.findAll();
        Set allCommunities = this.communityRepository.findAll();
        this.usersDAO.getAllUsers().forEach(user -> this.equipUser(user, allSites, allCommunities));
    }

    private void equipUser(FURMSUser user, Set<Site> allSites, Set<Community> allCommunities) {
        SiteExternalId siteId = this.addSiteAndMakeUserAdmin(user, allSites);
        this.addCommunityAndMakeUserAdmin(user, siteId, allCommunities);
    }

    private void addCommunityAndMakeUserAdmin(FURMSUser user, SiteExternalId siteId, Set<Community> allCommunities) {
        String emailHandle = this.getUserEmailHandle(user);
        if (allCommunities.stream().anyMatch(c -> c.getDescription().contains(emailHandle))) {
            return;
        }
        LOG.info("Adding community for for {}", (Object)user.email);
        Community community = Community.builder().name("PRACE-" + siteId.id).description("Community for " + emailHandle).logo(FurmsImage.empty()).build();
        String communityId = this.communityRepository.create(community);
        this.communityGroupsDAO.create(new CommunityGroup(communityId, community.getName()));
        LOG.info("Making user {} community {} admin", (Object)user.email, (Object)communityId);
        this.communityGroupsDAO.addAdmin(communityId, (PersistentId)user.id.orElseThrow());
    }

    private SiteExternalId addSiteAndMakeUserAdmin(FURMSUser user, Set<Site> allSites) {
        String emailHandle = this.getUserEmailHandle(user);
        Predicate<Site> siteForUser = site -> site.getConnectionInfo() != null && site.getConnectionInfo().contains(emailHandle);
        if (allSites.stream().anyMatch(siteForUser)) {
            return allSites.stream().filter(siteForUser).findAny().get().getExternalId();
        }
        LOG.info("Adding site for {}", (Object)user.email);
        SiteExternalId siteExternalId = this.generateSiteId();
        Site site2 = Site.builder().name("SITE-" + siteExternalId.id).connectionInfo("Site for " + emailHandle).build();
        String siteId = this.siteRepository.create(site2, siteExternalId);
        this.siteAgentService.initializeSiteConnection(siteExternalId);
        this.siteGroupDAO.create(Site.builder().id(siteId).name(site2.getName()).build());
        LOG.info("Making user {} site {} admin", (Object)user.email, (Object)siteId);
        this.siteGroupDAO.addSiteUser(siteId, (PersistentId)user.id.orElseThrow(), Role.SITE_ADMIN);
        return siteExternalId;
    }

    private SiteExternalId generateSiteId() {
        return new SiteExternalId(ExternalIdGenerator.generate(siteExternalId -> !this.siteRepository.existsByExternalId(new SiteExternalId(siteExternalId))));
    }

    private String getUserEmailHandle(FURMSUser user) {
        return user.email.split("@")[0];
    }
}

