/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.furms.server;

import io.imunity.furms.domain.authz.roles.Role;
import io.imunity.furms.domain.communities.Community;
import io.imunity.furms.domain.communities.CommunityGroup;
import io.imunity.furms.domain.community_allocation.CommunityAllocation;
import io.imunity.furms.domain.policy_documents.PolicyContentType;
import io.imunity.furms.domain.policy_documents.PolicyDocument;
import io.imunity.furms.domain.policy_documents.PolicyId;
import io.imunity.furms.domain.policy_documents.PolicyWorkflow;
import io.imunity.furms.domain.project_allocation.ProjectAllocation;
import io.imunity.furms.domain.project_allocation.ProjectAllocationResolved;
import io.imunity.furms.domain.project_allocation_installation.ProjectAllocationChunk;
import io.imunity.furms.domain.project_allocation_installation.ProjectAllocationInstallation;
import io.imunity.furms.domain.project_allocation_installation.ProjectAllocationInstallationStatus;
import io.imunity.furms.domain.project_installation.ProjectInstallationJob;
import io.imunity.furms.domain.project_installation.ProjectInstallationStatus;
import io.imunity.furms.domain.projects.Project;
import io.imunity.furms.domain.projects.ProjectGroup;
import io.imunity.furms.domain.resource_credits.ResourceCredit;
import io.imunity.furms.domain.resource_types.ResourceMeasureType;
import io.imunity.furms.domain.resource_types.ResourceMeasureUnit;
import io.imunity.furms.domain.resource_types.ResourceType;
import io.imunity.furms.domain.resource_usage.ResourceUsage;
import io.imunity.furms.domain.resource_usage.UserResourceUsage;
import io.imunity.furms.domain.services.InfraService;
import io.imunity.furms.domain.site_agent.CorrelationId;
import io.imunity.furms.domain.sites.Site;
import io.imunity.furms.domain.sites.SiteExternalId;
import io.imunity.furms.domain.users.FenixUserId;
import io.imunity.furms.domain.users.PersistentId;
import io.imunity.furms.server.UnityServerDetector;
import io.imunity.furms.site.api.site_agent.SiteAgentService;
import io.imunity.furms.spi.communites.CommunityGroupsDAO;
import io.imunity.furms.spi.communites.CommunityRepository;
import io.imunity.furms.spi.community_allocation.CommunityAllocationRepository;
import io.imunity.furms.spi.policy_docuemnts.PolicyDocumentRepository;
import io.imunity.furms.spi.project_allocation.ProjectAllocationRepository;
import io.imunity.furms.spi.project_allocation_installation.ProjectAllocationInstallationRepository;
import io.imunity.furms.spi.project_installation.ProjectOperationRepository;
import io.imunity.furms.spi.projects.ProjectGroupsDAO;
import io.imunity.furms.spi.projects.ProjectRepository;
import io.imunity.furms.spi.resource_credits.ResourceCreditRepository;
import io.imunity.furms.spi.resource_type.ResourceTypeRepository;
import io.imunity.furms.spi.resource_usage.ResourceUsageRepository;
import io.imunity.furms.spi.services.InfraServiceRepository;
import io.imunity.furms.spi.sites.SiteGroupDAO;
import io.imunity.furms.spi.sites.SiteRepository;
import io.imunity.furms.spi.users.UsersDAO;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.UUID;
import java.util.function.Function;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"demo-data-provisioning"})
class DemoDataInitializer
implements CommandLineRunner {
    private final CommunityRepository communityRepository;
    private final CommunityGroupsDAO communityGroupsDAO;
    private final SiteRepository siteRepository;
    private final SiteGroupDAO siteGroupDAO;
    private final UsersDAO usersDAO;
    private final ProjectRepository projectRepository;
    private final ProjectGroupsDAO projectGroupsDAO;
    private final UnityServerDetector unityDetector;
    private final InfraServiceRepository infraServiceRepository;
    private final ResourceTypeRepository resourceTypeRepository;
    private final ResourceCreditRepository resourceCreditRepository;
    private final CommunityAllocationRepository communityAllocationRepository;
    private final SiteAgentService siteAgentService;
    private final PolicyDocumentRepository policyDocumentRepository;
    private final ProjectAllocationRepository projectAllocationRepository;
    private final ProjectAllocationInstallationRepository projectAllocationInstallationRepository;
    private final ProjectOperationRepository projectOperationRepository;
    private final ResourceUsageRepository resourceUsageRepository;
    private String communityId;
    private String community2Id;
    private String projectId;
    private String project2Id;
    private String project3Id;
    private String project4Id;

    DemoDataInitializer(CommunityRepository communityRepository, CommunityGroupsDAO communityGroupsDAO, SiteRepository siteRepository, SiteGroupDAO siteGroupDAO, UsersDAO usersDAO, ProjectRepository projectRepository, ProjectGroupsDAO projectGroupsDAO, UnityServerDetector unityDetector, InfraServiceRepository infraServiceRepository, ResourceTypeRepository resourceTypeRepository, ResourceCreditRepository resourceCreditRepository, CommunityAllocationRepository communityAllocationRepository, SiteAgentService siteAgentService, PolicyDocumentRepository policyDocumentRepository, ProjectAllocationRepository projectAllocationRepository, ProjectAllocationInstallationRepository projectAllocationInstallationRepository, ProjectOperationRepository projectOperationRepository, ResourceUsageRepository resourceUsageRepository) {
        this.communityRepository = communityRepository;
        this.communityGroupsDAO = communityGroupsDAO;
        this.siteRepository = siteRepository;
        this.siteGroupDAO = siteGroupDAO;
        this.usersDAO = usersDAO;
        this.projectRepository = projectRepository;
        this.projectGroupsDAO = projectGroupsDAO;
        this.unityDetector = unityDetector;
        this.infraServiceRepository = infraServiceRepository;
        this.resourceTypeRepository = resourceTypeRepository;
        this.resourceCreditRepository = resourceCreditRepository;
        this.communityAllocationRepository = communityAllocationRepository;
        this.siteAgentService = siteAgentService;
        this.policyDocumentRepository = policyDocumentRepository;
        this.projectAllocationRepository = projectAllocationRepository;
        this.projectAllocationInstallationRepository = projectAllocationInstallationRepository;
        this.projectOperationRepository = projectOperationRepository;
        this.resourceUsageRepository = resourceUsageRepository;
    }

    public void run(String ... args) throws Exception {
        this.unityDetector.waitForUnityToStartUp();
        this.initCommunitiesAndProjects();
        this.initSites();
    }

    private void initCommunitiesAndProjects() throws IOException {
        PersistentId testAdminId = this.getPersistentId();
        if (this.communityRepository.findAll().isEmpty()) {
            byte[] imgHBPFile = this.getClass().getClassLoader().getResourceAsStream("demo/HBP.png").readAllBytes();
            Community community = Community.builder().name("HBP").description("Human Brain Project").logo(imgHBPFile, "png").build();
            byte[] imgPRACEFile = this.getClass().getClassLoader().getResourceAsStream("demo/PRACE.png").readAllBytes();
            Community community2 = Community.builder().name("PRACE").description("Partnership for Advance Computing").logo(imgPRACEFile, "png").build();
            this.communityId = this.communityRepository.create(community);
            this.communityGroupsDAO.create(new CommunityGroup(this.communityId, community.getName()));
            this.community2Id = this.communityRepository.create(community2);
            this.communityGroupsDAO.create(new CommunityGroup(this.community2Id, community2.getName()));
            this.communityGroupsDAO.addAdmin(this.communityId, testAdminId);
            Project project = Project.builder().name("Neuroinforamtics").communityId(this.communityId).description("Mouse Brain Project").logo(imgHBPFile, "png").acronym("NI").researchField("AI").utcStartTime(LocalDateTime.now()).utcEndTime(LocalDateTime.now().plusWeeks(20L)).leaderId(testAdminId).build();
            Project project2 = Project.builder().name("Brain simulation").communityId(this.communityId).description("Human Brain Project").logo(imgHBPFile, "png").acronym("BS").researchField("AI").utcStartTime(LocalDateTime.now()).utcEndTime(LocalDateTime.now().plusWeeks(10L)).leaderId(testAdminId).build();
            this.projectId = this.projectRepository.create(project);
            this.projectGroupsDAO.create(new ProjectGroup(this.projectId, project.getName(), this.communityId));
            this.project2Id = this.projectRepository.create(project2);
            this.projectGroupsDAO.create(new ProjectGroup(this.project2Id, project2.getName(), this.communityId));
            this.projectGroupsDAO.addProjectUser(this.communityId, this.projectId, testAdminId, Role.PROJECT_ADMIN);
            this.projectGroupsDAO.addProjectUser(this.communityId, this.project2Id, testAdminId, Role.PROJECT_ADMIN);
            Project project3 = Project.builder().name("Neuroinforamtics2").communityId(this.community2Id).description("Mouse Brain Project").logo(imgHBPFile, "png").acronym("NI").researchField("AI").utcStartTime(LocalDateTime.now()).utcEndTime(LocalDateTime.now().plusWeeks(30L)).leaderId(testAdminId).build();
            Project project4 = Project.builder().name("Brain simulation2").communityId(this.community2Id).description("Human Brain Project").logo(imgHBPFile, "png").acronym("BS").researchField("AI").utcStartTime(LocalDateTime.now()).utcEndTime(LocalDateTime.now().plusWeeks(13L)).leaderId(testAdminId).build();
            this.project3Id = this.projectRepository.create(project3);
            this.projectGroupsDAO.create(new ProjectGroup(this.project3Id, project3.getName(), this.community2Id));
            this.project4Id = this.projectRepository.create(project4);
            this.projectGroupsDAO.create(new ProjectGroup(this.project4Id, project4.getName(), this.community2Id));
            this.projectGroupsDAO.addProjectUser(this.community2Id, this.project3Id, testAdminId, Role.PROJECT_ADMIN);
            this.projectGroupsDAO.addProjectUser(this.community2Id, this.project4Id, testAdminId, Role.PROJECT_ADMIN);
        }
    }

    private PersistentId getPersistentId() {
        return this.usersDAO.getAllUsers().stream().filter(user -> user.email.equals("admin@not-existing-1qaz.example.com")).map(user -> user.id).findAny().flatMap(Function.identity()).orElse(null);
    }

    private void initSites() {
        if (this.siteRepository.findAll().isEmpty()) {
            PersistentId testAdminId = this.getPersistentId();
            Site cineca = Site.builder().name("CINECA").build();
            Site fzj = Site.builder().name("FZJ").build();
            Site bsc = Site.builder().name("BSC").build();
            SiteExternalId ciencaExternalId = new SiteExternalId("cin-x");
            SiteExternalId fzjExternalId = new SiteExternalId("fzj-x");
            SiteExternalId bscExternalId = new SiteExternalId("bsc-x");
            String cinecaId = this.siteRepository.create(cineca, ciencaExternalId);
            String fzjId = this.siteRepository.create(fzj, fzjExternalId);
            String bscId = this.siteRepository.create(bsc, bscExternalId);
            this.siteAgentService.initializeSiteConnection(ciencaExternalId);
            this.siteAgentService.initializeSiteConnection(fzjExternalId);
            this.siteAgentService.initializeSiteConnection(bscExternalId);
            this.siteGroupDAO.create(Site.builder().id(cinecaId).name(cineca.getName()).build());
            this.siteGroupDAO.create(Site.builder().id(fzjId).name(fzj.getName()).build());
            this.siteGroupDAO.create(Site.builder().id(bscId).name(bsc.getName()).build());
            this.siteGroupDAO.addSiteUser(cinecaId, testAdminId, Role.SITE_ADMIN);
            PolicyDocument policyDocument = PolicyDocument.builder().name("Cineca site policy").workflow(PolicyWorkflow.WEB_BASED).contentType(PolicyContentType.EMBEDDED).wysiwygText("<div><p>TEXT</p></div>").revision(1).siteId(cinecaId).build();
            PolicyDocument policyDocument1 = PolicyDocument.builder().name("Service policy").workflow(PolicyWorkflow.PAPER_BASED).contentType(PolicyContentType.EMBEDDED).wysiwygText("<div><p>TEXT</p></div>").revision(1).siteId(cinecaId).build();
            PolicyId policyId = this.policyDocumentRepository.create(policyDocument);
            PolicyId policyId1 = this.policyDocumentRepository.create(policyDocument1);
            Site updateCineca = Site.builder().id(cinecaId).externalId(ciencaExternalId).policyId(policyId).name("CINECA").build();
            this.siteRepository.update(updateCineca);
            InfraService infraServiceCineca = InfraService.builder().name("Virtual Machines").siteId(cinecaId).description("Service for deploying virtual machines").policyId(policyId1).build();
            InfraService infraServiceCineca1 = InfraService.builder().name("Archive Cineca").siteId(cinecaId).description("Archive Cineca").policyId(policyId1).build();
            InfraService infraServiceFzj = InfraService.builder().name("Cluster Fzj").siteId(fzjId).description("Cluster Fzj").build();
            InfraService infraServiceFzj1 = InfraService.builder().name("Archive Fzj").siteId(fzjId).description("Archive Fzj").build();
            InfraService infraServiceBsc = InfraService.builder().name("Cluster Bsc").siteId(bscId).description("Cluster Bsc").build();
            InfraService infraServiceBsc1 = InfraService.builder().name("Archive Bsc").siteId(bscId).description("Archive Bsc").build();
            String serviceCinecaId = this.infraServiceRepository.create(infraServiceCineca);
            String serviceCinecaId1 = this.infraServiceRepository.create(infraServiceCineca1);
            String serviceFzjId = this.infraServiceRepository.create(infraServiceFzj);
            String serviceFzjId1 = this.infraServiceRepository.create(infraServiceFzj1);
            String serviceBscId = this.infraServiceRepository.create(infraServiceBsc);
            String serviceBscId1 = this.infraServiceRepository.create(infraServiceBsc1);
            ResourceType resourceTypeCineca = ResourceType.builder().siteId(cinecaId).serviceId(serviceCinecaId).name("Cineca Vector CPU Time").type(ResourceMeasureType.TIME).unit(ResourceMeasureUnit.H).build();
            ResourceType resourceTypeCineca1 = ResourceType.builder().siteId(cinecaId).serviceId(serviceCinecaId1).name("Cineca Disk Space").type(ResourceMeasureType.DATA).unit(ResourceMeasureUnit.GB).build();
            ResourceType resourceTypeFzj = ResourceType.builder().siteId(fzjId).serviceId(serviceFzjId).name("Fzj Vector GPU Time").type(ResourceMeasureType.TIME).unit(ResourceMeasureUnit.MIN).build();
            ResourceType resourceTypeFzj1 = ResourceType.builder().siteId(fzjId).serviceId(serviceFzjId1).name("Fzj Storage").type(ResourceMeasureType.DATA).unit(ResourceMeasureUnit.PB).build();
            ResourceType resourceTypeBsc = ResourceType.builder().siteId(bscId).serviceId(serviceBscId).name("BSC Vector CPU Time").type(ResourceMeasureType.TIME).unit(ResourceMeasureUnit.DAY).build();
            ResourceType resourceTypeBsc1 = ResourceType.builder().siteId(bscId).serviceId(serviceBscId1).name("BSC Disk").type(ResourceMeasureType.DATA).unit(ResourceMeasureUnit.KB).build();
            String resourceTypeCinecaId = this.resourceTypeRepository.create(resourceTypeCineca);
            String resourceTypeCinecaId1 = this.resourceTypeRepository.create(resourceTypeCineca1);
            String resourceTypeFzjId = this.resourceTypeRepository.create(resourceTypeFzj);
            String resourceTypeFzjId1 = this.resourceTypeRepository.create(resourceTypeFzj1);
            String resourceTypeBscId = this.resourceTypeRepository.create(resourceTypeBsc);
            String resourceTypeBscId1 = this.resourceTypeRepository.create(resourceTypeBsc1);
            ResourceCredit resourceCreditCineca = ResourceCredit.builder().siteId(cinecaId).resourceTypeId(resourceTypeCinecaId).name("First Cineca pool").amount(new BigDecimal(100)).utcStartTime(LocalDateTime.of(2021, 2, 11, 16, 11)).utcEndTime(LocalDateTime.of(2025, 4, 11, 16, 11)).build();
            ResourceCredit resourceCreditCineca1 = ResourceCredit.builder().siteId(cinecaId).resourceTypeId(resourceTypeCinecaId1).name("Second Cineca pool").amount(new BigDecimal(546)).utcStartTime(LocalDateTime.of(2021, 3, 9, 1, 22)).utcEndTime(LocalDateTime.of(2024, 5, 3, 6, 32)).build();
            ResourceCredit resourceCreditFzj = ResourceCredit.builder().siteId(fzjId).resourceTypeId(resourceTypeFzjId).name("First Fzj pool").amount(new BigDecimal(643)).utcStartTime(LocalDateTime.of(2021, 2, 7, 4, 22)).utcEndTime(LocalDateTime.of(2021, 4, 9, 7, 32)).build();
            ResourceCredit resourceCreditFzj1 = ResourceCredit.builder().siteId(fzjId).resourceTypeId(resourceTypeFzjId1).name("Second Fzj pool").amount(new BigDecimal(754)).utcStartTime(LocalDateTime.of(2021, 4, 23, 3, 22)).utcEndTime(LocalDateTime.of(2024, 8, 12, 5, 32)).build();
            ResourceCredit resourceCreditBsc = ResourceCredit.builder().siteId(bscId).resourceTypeId(resourceTypeBscId).name("First Bsc pool").amount(new BigDecimal(112)).utcStartTime(LocalDateTime.of(2021, 3, 11, 6, 22)).utcEndTime(LocalDateTime.of(2024, 6, 22, 7, 32)).build();
            ResourceCredit resourceCreditBsc1 = ResourceCredit.builder().siteId(bscId).resourceTypeId(resourceTypeBscId1).name("Second Bsc pool").amount(new BigDecimal(9875)).utcStartTime(LocalDateTime.of(2021, 10, 22, 11, 22)).utcEndTime(LocalDateTime.of(2024, 12, 8, 17, 32)).build();
            String resourceCreditCinecaId1 = this.resourceCreditRepository.create(resourceCreditCineca);
            this.resourceCreditRepository.create(resourceCreditCineca1);
            this.resourceCreditRepository.create(resourceCreditFzj);
            String resourceCreditFzjId1 = this.resourceCreditRepository.create(resourceCreditFzj1);
            this.resourceCreditRepository.create(resourceCreditBsc);
            String resourceCreditBscId1 = this.resourceCreditRepository.create(resourceCreditBsc1);
            CommunityAllocation communityAllocation = CommunityAllocation.builder().communityId(this.communityId).resourceCreditId(resourceCreditBscId1).name("First Allocation").amount(new BigDecimal(1000)).build();
            CommunityAllocation communityAllocation1 = CommunityAllocation.builder().communityId(this.community2Id).resourceCreditId(resourceCreditFzjId1).name("Second Allocation").amount(new BigDecimal(500)).build();
            CommunityAllocation communityAllocation2 = CommunityAllocation.builder().communityId(this.communityId).resourceCreditId(resourceCreditCinecaId1).name("HBP Cineca Allocation").amount(new BigDecimal(50)).build();
            CommunityAllocation communityAllocation3 = CommunityAllocation.builder().communityId(this.communityId).resourceCreditId(resourceCreditCinecaId1).name("HBP Cineca Allocation 2").amount(new BigDecimal(50)).build();
            this.communityAllocationRepository.create(communityAllocation);
            this.communityAllocationRepository.create(communityAllocation1);
            String communityAllocationId = this.communityAllocationRepository.create(communityAllocation2);
            String communityAllocationId1 = this.communityAllocationRepository.create(communityAllocation3);
            ProjectAllocation projectAllocation = ProjectAllocation.builder().projectId(this.projectId).name("Neuroinforamtics Cineca Allocation").amount(new BigDecimal(20)).communityAllocationId(communityAllocationId).build();
            String projectAllocationId = this.projectAllocationRepository.create(projectAllocation);
            ProjectAllocationInstallation projectAllocationInstallation = ProjectAllocationInstallation.builder().projectAllocationId(projectAllocationId).siteId(cinecaId).status(ProjectAllocationInstallationStatus.ACKNOWLEDGED).correlationId(new CorrelationId(UUID.randomUUID().toString())).build();
            this.projectAllocationInstallationRepository.create(projectAllocationInstallation);
            ProjectAllocationChunk projectAllocationChunk = ProjectAllocationChunk.builder().amount(new BigDecimal(5)).projectAllocationId(projectAllocationId).chunkId("1").validFrom(LocalDateTime.now().minusMonths(2L)).validTo(LocalDateTime.now().plusDays(20L)).receivedTime(LocalDateTime.now().minusMonths(2L)).build();
            this.projectAllocationInstallationRepository.create(projectAllocationChunk);
            ProjectAllocationChunk projectAllocationChunk1 = ProjectAllocationChunk.builder().amount(new BigDecimal(3)).projectAllocationId(projectAllocationId).chunkId("2").validFrom(LocalDateTime.now().minusMonths(1L)).validTo(LocalDateTime.now().plusDays(25L)).receivedTime(LocalDateTime.now().minusMonths(1L)).build();
            this.projectAllocationInstallationRepository.create(projectAllocationChunk1);
            ProjectAllocationChunk projectAllocationChunk2 = ProjectAllocationChunk.builder().amount(new BigDecimal(4)).projectAllocationId(projectAllocationId).chunkId("3").validFrom(LocalDateTime.now().minusDays(15L)).validTo(LocalDateTime.now().plusDays(27L)).receivedTime(LocalDateTime.now().minusDays(15L)).build();
            this.projectAllocationInstallationRepository.create(projectAllocationChunk2);
            ProjectAllocationChunk projectAllocationChunk3 = ProjectAllocationChunk.builder().amount(new BigDecimal(3)).projectAllocationId(projectAllocationId).chunkId("3").validFrom(LocalDateTime.now().minusDays(2L)).validTo(LocalDateTime.now().plusDays(35L)).receivedTime(LocalDateTime.now().minusDays(2L)).build();
            this.projectAllocationInstallationRepository.create(projectAllocationChunk3);
            ProjectAllocationResolved projectAllocationResolved = (ProjectAllocationResolved)this.projectAllocationRepository.findByIdWithRelatedObjects(projectAllocationId).get();
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(1)).probedAt(LocalDateTime.now().minusDays(59L)).build(), projectAllocationResolved);
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(2)).probedAt(LocalDateTime.now().minusDays(50L)).build(), projectAllocationResolved);
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(5)).probedAt(LocalDateTime.now().minusDays(40L)).build(), projectAllocationResolved);
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(8)).probedAt(LocalDateTime.now().minusDays(25L)).build(), projectAllocationResolved);
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(10)).probedAt(LocalDateTime.now().minusDays(15L)).build(), projectAllocationResolved);
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(13)).probedAt(LocalDateTime.now().minusDays(5L)).build(), projectAllocationResolved);
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(16)).probedAt(LocalDateTime.now().minusDays(1L)).build(), projectAllocationResolved);
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(1)).fenixUserId(new FenixUserId("usr1@email.com")).consumedUntil(LocalDateTime.now().minusDays(59L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(1)).fenixUserId(new FenixUserId("usr2@email.com")).consumedUntil(LocalDateTime.now().minusDays(54L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(2)).fenixUserId(new FenixUserId("usr2@email.com")).consumedUntil(LocalDateTime.now().minusDays(49L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(2)).fenixUserId(new FenixUserId("usr1@email.com")).consumedUntil(LocalDateTime.now().minusDays(45L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(1)).fenixUserId(new FenixUserId("usr3@email.com")).consumedUntil(LocalDateTime.now().minusDays(42L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(4)).fenixUserId(new FenixUserId("usr3@email.com")).consumedUntil(LocalDateTime.now().minusDays(28L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(3)).fenixUserId(new FenixUserId("usr1@email.com")).consumedUntil(LocalDateTime.now().minusDays(17L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(3)).fenixUserId(new FenixUserId("usr2@email.com")).consumedUntil(LocalDateTime.now().minusDays(16L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(5)).fenixUserId(new FenixUserId("usr1@email.com")).consumedUntil(LocalDateTime.now().minusDays(10L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(5)).fenixUserId(new FenixUserId("usr3@email.com")).consumedUntil(LocalDateTime.now().minusDays(7L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(4)).fenixUserId(new FenixUserId("usr2@email.com")).consumedUntil(LocalDateTime.now().minusDays(4L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId).cumulativeConsumption(new BigDecimal(5)).fenixUserId(new FenixUserId("usr2@email.com")).consumedUntil(LocalDateTime.now().minusDays(2L)).build());
            ProjectAllocation projectAllocation1 = ProjectAllocation.builder().projectId(this.projectId).name("Neuroinforamtics Cineca Allocation 2").amount(new BigDecimal(20)).communityAllocationId(communityAllocationId).build();
            String projectAllocationId1 = this.projectAllocationRepository.create(projectAllocation1);
            ProjectAllocationInstallation projectAllocationInstallation1 = ProjectAllocationInstallation.builder().projectAllocationId(projectAllocationId1).siteId(cinecaId).status(ProjectAllocationInstallationStatus.ACKNOWLEDGED).correlationId(new CorrelationId(UUID.randomUUID().toString())).build();
            this.projectAllocationInstallationRepository.create(projectAllocationInstallation1);
            ProjectAllocationChunk projectAllocationChunk10 = ProjectAllocationChunk.builder().amount(new BigDecimal(5)).projectAllocationId(projectAllocationId1).chunkId("1").validFrom(LocalDateTime.now().minusMonths(2L)).validTo(LocalDateTime.now().plusDays(20L)).receivedTime(LocalDateTime.now().minusMonths(2L)).build();
            this.projectAllocationInstallationRepository.create(projectAllocationChunk10);
            ProjectAllocationChunk projectAllocationChunk11 = ProjectAllocationChunk.builder().amount(new BigDecimal(3)).projectAllocationId(projectAllocationId1).chunkId("2").validFrom(LocalDateTime.now().minusMonths(1L)).validTo(LocalDateTime.now().plusDays(25L)).receivedTime(LocalDateTime.now().minusMonths(1L)).build();
            this.projectAllocationInstallationRepository.create(projectAllocationChunk11);
            ProjectAllocationChunk projectAllocationChunk12 = ProjectAllocationChunk.builder().amount(new BigDecimal(4)).projectAllocationId(projectAllocationId1).chunkId("3").validFrom(LocalDateTime.now().minusDays(15L)).validTo(LocalDateTime.now().plusDays(27L)).receivedTime(LocalDateTime.now().minusDays(15L)).build();
            this.projectAllocationInstallationRepository.create(projectAllocationChunk12);
            ProjectAllocationChunk projectAllocationChunk13 = ProjectAllocationChunk.builder().amount(new BigDecimal(3)).projectAllocationId(projectAllocationId1).chunkId("3").validFrom(LocalDateTime.now().minusDays(2L)).validTo(LocalDateTime.now().plusDays(35L)).receivedTime(LocalDateTime.now().minusDays(2L)).build();
            this.projectAllocationInstallationRepository.create(projectAllocationChunk13);
            ProjectAllocationResolved projectAllocationResolved1 = (ProjectAllocationResolved)this.projectAllocationRepository.findByIdWithRelatedObjects(projectAllocationId1).get();
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(1)).probedAt(LocalDateTime.now().minusDays(59L)).build(), projectAllocationResolved1);
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(2)).probedAt(LocalDateTime.now().minusDays(50L)).build(), projectAllocationResolved1);
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(5)).probedAt(LocalDateTime.now().minusDays(40L)).build(), projectAllocationResolved1);
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(8)).probedAt(LocalDateTime.now().minusDays(25L)).build(), projectAllocationResolved1);
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(10)).probedAt(LocalDateTime.now().minusDays(15L)).build(), projectAllocationResolved1);
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(13)).probedAt(LocalDateTime.now().minusDays(5L)).build(), projectAllocationResolved1);
            this.resourceUsageRepository.create(ResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(16)).probedAt(LocalDateTime.now().minusDays(1L)).build(), projectAllocationResolved1);
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(1)).fenixUserId(new FenixUserId("usr1@email.com")).consumedUntil(LocalDateTime.now().minusDays(59L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(1)).fenixUserId(new FenixUserId("usr2@email.com")).consumedUntil(LocalDateTime.now().minusDays(54L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(2)).fenixUserId(new FenixUserId("usr2@email.com")).consumedUntil(LocalDateTime.now().minusDays(49L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(2)).fenixUserId(new FenixUserId("usr1@email.com")).consumedUntil(LocalDateTime.now().minusDays(45L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(1)).fenixUserId(new FenixUserId("usr3@email.com")).consumedUntil(LocalDateTime.now().minusDays(42L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(4)).fenixUserId(new FenixUserId("usr3@email.com")).consumedUntil(LocalDateTime.now().minusDays(28L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(3)).fenixUserId(new FenixUserId("usr1@email.com")).consumedUntil(LocalDateTime.now().minusDays(17L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(3)).fenixUserId(new FenixUserId("usr2@email.com")).consumedUntil(LocalDateTime.now().minusDays(16L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(5)).fenixUserId(new FenixUserId("usr1@email.com")).consumedUntil(LocalDateTime.now().minusDays(10L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(5)).fenixUserId(new FenixUserId("usr3@email.com")).consumedUntil(LocalDateTime.now().minusDays(7L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(4)).fenixUserId(new FenixUserId("usr2@email.com")).consumedUntil(LocalDateTime.now().minusDays(4L)).build());
            this.resourceUsageRepository.create(UserResourceUsage.builder().projectId(this.projectId).projectAllocationId(projectAllocationId1).cumulativeConsumption(new BigDecimal(5)).fenixUserId(new FenixUserId("usr2@email.com")).consumedUntil(LocalDateTime.now().minusDays(2L)).build());
            ProjectInstallationJob projectInstallationJob = ProjectInstallationJob.builder().gid("gid").siteId(cinecaId).projectId(this.projectId).correlationId(CorrelationId.randomID()).status(ProjectInstallationStatus.INSTALLED).build();
            this.projectOperationRepository.createOrUpdate(projectInstallationJob);
            ProjectInstallationJob projectInstallationJob2 = ProjectInstallationJob.builder().gid("gid").siteId(cinecaId).projectId(this.project2Id).correlationId(CorrelationId.randomID()).status(ProjectInstallationStatus.INSTALLED).build();
            this.projectOperationRepository.createOrUpdate(projectInstallationJob2);
            ProjectInstallationJob projectInstallationJob3 = ProjectInstallationJob.builder().gid("gid").siteId(cinecaId).projectId(this.project3Id).correlationId(CorrelationId.randomID()).status(ProjectInstallationStatus.INSTALLED).build();
            this.projectOperationRepository.createOrUpdate(projectInstallationJob3);
            ProjectInstallationJob projectInstallationJob4 = ProjectInstallationJob.builder().gid("gid").siteId(cinecaId).projectId(this.project4Id).correlationId(CorrelationId.randomID()).status(ProjectInstallationStatus.INSTALLED).build();
            this.projectOperationRepository.createOrUpdate(projectInstallationJob4);
        }
    }
}

