/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.furms.server;

import io.imunity.furms.spi.mtc.UnityMonitoringDAO;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

@Controller
class UnityServerDetector {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final UnityMonitoringDAO monitoringDAO;

    UnityServerDetector(UnityMonitoringDAO monitoringDAO) {
        this.monitoringDAO = monitoringDAO;
    }

    void waitForUnityToStartUp() throws InterruptedException {
        for (long retryCount = 1L; retryCount <= 120L; ++retryCount) {
            if (this.isUnityAvailable()) {
                LOG.debug("Unity is up and running");
                return;
            }
            LOG.info("Waiting for unity.");
            TimeUnit.SECONDS.sleep(1L);
        }
    }

    private boolean isUnityAvailable() {
        try {
            this.monitoringDAO.ping();
            return true;
        }
        catch (UnityMonitoringDAO.UnityConnectException e) {
            LOG.trace("Unity is not yet available.", (Throwable)e);
            return false;
        }
    }
}

