/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils;

import io.inbot.utils.HashUtils;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESUtils {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\$");

    public static String generateAesKey() {
        byte[] newKey = new byte[32];
        SECURE_RANDOM.nextBytes(newKey);
        return Base64.encodeBase64String((byte[])newKey);
    }

    public static String decrypt(String salt, String password, String input) {
        return AESUtils.decryptBouncyCastle(AESUtils.getKey(salt, password), input);
    }

    public static String decrypt(byte[] key256Bits, String encrypted) {
        SecretKeySpec secretKey = new SecretKeySpec(key256Bits, "AES");
        return AESUtils.decryptBouncyCastle(secretKey, encrypted);
    }

    public static String decrypt(String keyBase64, String encrypted) {
        return AESUtils.decrypt(Base64.decodeBase64((byte[])keyBase64.getBytes(StandardCharsets.UTF_8)), encrypted);
    }

    private static String encryptBouncyCastle(SecretKey secret, String plainText) {
        try {
            String md5 = HashUtils.md5(plainText);
            plainText = md5 + plainText;
            byte[] iv = new byte[16];
            SECURE_RANDOM.nextBytes(iv);
            byte[] key = secret.getEncoded();
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()), (BlockCipherPadding)new PKCS7Padding());
            cipher.reset();
            cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
            byte[] plainTextBuf = plainText.getBytes(StandardCharsets.UTF_8);
            byte[] buf = new byte[cipher.getOutputSize(plainTextBuf.length)];
            int len = cipher.processBytes(plainTextBuf, 0, plainTextBuf.length, buf, 0);
            len += cipher.doFinal(buf, len);
            byte[] out = new byte[len];
            System.arraycopy(buf, 0, out, 0, len);
            return AESUtils.byteArrayToHexString(iv) + "$" + new String(Base64.encodeBase64URLSafe((byte[])out), StandardCharsets.UTF_8);
        }
        catch (DataLengthException | InvalidCipherTextException e) {
            throw new IllegalStateException("cannot encrypt", e);
        }
    }

    private static String decryptBouncyCastle(SecretKey secret, String input) {
        try {
            input = input.replaceAll("-", "+").replaceAll("_", "/").replaceAll("\r", "").replaceAll("\n", "");
            String[] splitInput = SPLIT_PATTERN.split(input);
            byte[] iv = AESUtils.hexStringToByteArray(splitInput[0]);
            byte[] encrypted = Base64.decodeBase64((String)splitInput[1]);
            byte[] key = secret.getEncoded();
            KeyParameter keyParam = new KeyParameter(key);
            ParametersWithIV params = new ParametersWithIV((CipherParameters)keyParam, iv);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()), (BlockCipherPadding)new PKCS7Padding());
            cipher.reset();
            cipher.init(false, (CipherParameters)params);
            byte[] buf = new byte[cipher.getOutputSize(encrypted.length)];
            int len = cipher.processBytes(encrypted, 0, encrypted.length, buf, 0);
            len += cipher.doFinal(buf, len);
            byte[] out = new byte[len];
            System.arraycopy(buf, 0, out, 0, len);
            String plaintext = new String(out, StandardCharsets.UTF_8);
            String md5Hash = plaintext.substring(0, 22);
            String plainTextWithoutHash = plaintext.substring(22);
            if (md5Hash.equals(HashUtils.md5(plainTextWithoutHash))) {
                return plainTextWithoutHash;
            }
            throw new IllegalArgumentException("wrong aes key - incorrect content hash");
        }
        catch (DataLengthException e) {
            throw new IllegalStateException("buffer not big enough", e);
        }
        catch (InvalidCipherTextException e) {
            throw new IllegalArgumentException("wrong password");
        }
    }

    public static String encrypt(byte[] key256Bits, String plainText) {
        SecretKeySpec secretKey = new SecretKeySpec(key256Bits, "AES");
        return AESUtils.encryptBouncyCastle(secretKey, plainText);
    }

    public static String encrypt(String key, String plainText) {
        SecretKeySpec secret = new SecretKeySpec(Base64.decodeBase64((byte[])key.getBytes()), "AES");
        return AESUtils.encryptBouncyCastle(secret, plainText);
    }

    public static String encrypt(String salt, String password, String plainText) {
        SecretKey secret = AESUtils.getKey(salt, password);
        return AESUtils.encryptBouncyCastle(secret, plainText);
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    private static SecretKey getKey(String salt, String password) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), 1000, 256);
            SecretKey tmp = factory.generateSecret(spec);
            return new SecretKeySpec(tmp.getEncoded(), "AES");
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("cannot create key: " + e.getMessage(), e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

