/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ArrayFoo {
    @SafeVarargs
    public static <T> T[] combine(T[] ... arrays) {
        Validate.isTrue((arrays.length > 0 ? 1 : 0) != 0, (String)"should have at least one element", (Object[])new Object[0]);
        if (arrays.length == 1) {
            return arrays[0];
        }
        int totalSize = Arrays.stream(arrays).mapToInt(a -> ((Object[])a).length).sum();
        ArrayList<T> list = new ArrayList<T>(totalSize);
        T[][] TArray = arrays;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T[] ts;
            for (T t : ts = TArray[i]) {
                list.add(t);
            }
        }
        return list.toArray(arrays[0]);
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... ts) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T t : ts) {
            set.add(t);
        }
        return Collections.unmodifiableSet(set);
    }

    public static <T> String stringify(T[] ts) {
        return "[" + StringUtils.join((Object[])ts, (char)',') + "]";
    }

    public static <T> String stringify(Collection<?> ts) {
        return "[" + StringUtils.join(ts, (char)',') + "]";
    }

    public static <T> boolean arrayContains(T[] ts, T value) {
        if (ts == null) {
            return false;
        }
        for (T t : ts) {
            if (!t.equals(value)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> T[] array(T ... ts) {
        return ts;
    }

    public static <T> T[] array(Collection<T> ts) {
        Validate.isTrue((ts.size() > 0 ? 1 : 0) != 0, (String)"should have at least one element", (Object[])new Object[0]);
        return ts.toArray((Object[])Array.newInstance(ts.iterator().next().getClass(), 0));
    }
}

