/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class HashUtils {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    public static String base64Encode(String s) {
        byte[] bytes = Base64.encodeBase64((byte[])s.getBytes(StandardCharsets.UTF_8));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String base64Decode(String s) {
        byte[] bytes = Base64.decodeBase64((byte[])s.getBytes());
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String sha1(Object ... values) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            for (Object value : values) {
                String v;
                if (value == null || !StringUtils.isNotBlank((CharSequence)(v = value.toString()))) continue;
                md.update(v.getBytes(StandardCharsets.UTF_8));
            }
            return Base64.encodeBase64URLSafeString((byte[])md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String md5(Collection<?> values) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (Object value : values) {
                if (value == null) continue;
                md.update(value.toString().getBytes(StandardCharsets.UTF_8));
            }
            return Base64.encodeBase64URLSafeString((byte[])md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String md5(Object ... values) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (Object value : values) {
                if (value == null) continue;
                md.update(value.toString().getBytes(StandardCharsets.UTF_8));
            }
            return Base64.encodeBase64URLSafeString((byte[])md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String md5(byte[] ... values) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (byte[] value : values) {
                if (value == null) continue;
                md.update(value);
            }
            return Base64.encodeBase64URLSafeString((byte[])md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String md5Hex(Object ... values) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (Object value : values) {
                if (value == null) continue;
                md.update(value.toString().getBytes(StandardCharsets.UTF_8));
            }
            return HashUtils.hex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String hex(byte[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public static String createId() {
        String id = HashUtils.md5(UUID.randomUUID().toString());
        while (id.startsWith("_") || id.toLowerCase(Locale.ENGLISH).contains("null")) {
            id = HashUtils.md5(UUID.randomUUID().toString());
        }
        return id;
    }

    public static String bitString(long number) {
        return String.format("%064d", new BigInteger(Long.toBinaryString(number)));
    }

    public static String secureToken() {
        String tok;
        while ((tok = new BigInteger(128, SECURE_RANDOM).toString(32)).toLowerCase(Locale.ENGLISH).contains("null")) {
        }
        return tok;
    }
}

