/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils;

import com.google.common.io.CountingOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IOUtils {
    public static BufferedReader resource(String resourcePath) throws IOException {
        InputStream is = IOUtils.class.getClassLoader().getResourceAsStream(resourcePath);
        if (is != null) {
            return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        }
        File file = new File(resourcePath);
        if (file.exists()) {
            return IOUtils.fileReader(file);
        }
        throw new IllegalArgumentException("resource does not exist " + resourcePath);
    }

    public long byteCount(Object object) {
        try {
            CountingOutputStream cos = new CountingOutputStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            });
            ObjectOutputStream os = new ObjectOutputStream((OutputStream)cos);
            os.writeObject(object);
            os.flush();
            os.close();
            return cos.getCount();
        }
        catch (IOException e) {
            throw new IllegalStateException("error serializing object: " + e.getMessage(), e);
        }
    }

    public static BufferedWriter gzipFileWriter(String file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(file)), StandardCharsets.UTF_8));
    }

    public static BufferedWriter gzipFileWriter(File file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(file)), StandardCharsets.UTF_8), 65536);
    }

    public static BufferedWriter fileWriter(String file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
    }

    public static BufferedWriter fileWriter(File file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
    }

    public static BufferedReader gzipFileReader(String file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), StandardCharsets.UTF_8));
    }

    public static BufferedReader gzipFileReader(File file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), StandardCharsets.UTF_8));
    }

    public static BufferedReader fileReader(String file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
    }

    public static BufferedReader fileReader(File file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(BufferedReader r) {
        String string;
        try {
            String line;
            StringBuilder buf = new StringBuilder();
            while ((line = r.readLine()) != null) {
                buf.append(line + '\n');
            }
            string = buf.toString();
        }
        catch (Throwable throwable) {
            try {
                r.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        r.close();
        return string;
    }

    public static String readString(InputStream is) {
        return IOUtils.readString(new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)));
    }

    public static byte[] readBytes(InputStream is) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            int b;
            while ((b = ((InputStream)bis).read()) >= 0) {
                bos.write(b);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return bos.toByteArray();
    }

    public static Stream<String> lines(String resourceOrFile) {
        try {
            return IOUtils.resource(resourceOrFile).lines();
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot read resource", e);
        }
    }
}

