/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Date;
import java.util.function.Consumer;

public class JwtTokenCreationService {
    private final ECPrivateKey ecPrivateKey;
    private final ECPublicKey ecPublicKey;
    private String issuer;
    private int defaultExpirationMs;

    public JwtTokenCreationService(ECPrivateKey ecPrivateKey, ECPublicKey ecPublicKey, String issuer, int defaultExpirationMs) {
        this.ecPrivateKey = ecPrivateKey;
        this.ecPublicKey = ecPublicKey;
        this.issuer = issuer;
        this.defaultExpirationMs = defaultExpirationMs;
    }

    public String create(Consumer<JWTCreator.Builder> jwtBuilderConsumer) {
        Date issueTime = new Date();
        Date expirationTime = new Date(issueTime.getTime() + (long)this.defaultExpirationMs);
        JWTCreator.Builder builder = JWT.create().withIssuer(this.issuer).withIssuedAt(issueTime).withExpiresAt(expirationTime);
        jwtBuilderConsumer.accept(builder);
        return builder.sign(Algorithm.ECDSA512((ECPublicKey)this.ecPublicKey, (ECPrivateKey)this.ecPrivateKey));
    }
}

