/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Verification;
import java.security.interfaces.ECPublicKey;
import java.util.function.Consumer;

public class JwtVerificationService {
    private final ECPublicKey ecPublicKey;
    private final String issuer;

    public JwtVerificationService(ECPublicKey ecPublicKey, String issuer) {
        this.ecPublicKey = ecPublicKey;
        this.issuer = issuer;
    }

    public boolean isValid(String token, Consumer<Verification> verificationConsumer) throws IllegalArgumentException {
        try {
            this.verify(token, verificationConsumer);
            return true;
        }
        catch (JWTVerificationException e) {
            return false;
        }
    }

    public void verify(String token, Consumer<Verification> verificationConsumer) throws JWTVerificationException, IllegalArgumentException {
        Verification verifierBuilder = JWT.require((Algorithm)Algorithm.ECDSA512((ECPublicKey)this.ecPublicKey, null)).withIssuer(this.issuer);
        verificationConsumer.accept(verifierBuilder);
        JWTVerifier verifier = verifierBuilder.build();
        verifier.verify(token);
    }
}

