/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class KeyPairUtils {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    public static KeyPair generateECKeyPair() {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
            kpg.initialize(new ECGenParameterSpec("secp384r1"), SECURE_RANDOM);
            return kpg.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("problem " + e.getMessage(), e);
        }
    }

    public static String privateKey2String(PrivateKey key) {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(key.getEncoded());
        return new String(Base64.getEncoder().encode(spec.getEncoded()), StandardCharsets.UTF_8);
    }

    public static String publicKey2String(PublicKey key) {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(key.getEncoded());
        return new String(Base64.getEncoder().encode(spec.getEncoded()), StandardCharsets.UTF_8);
    }

    public static ECPublicKey decodePublicKey(String keyString) {
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(Base64.getDecoder().decode(keyString.getBytes(StandardCharsets.UTF_8)));
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return (ECPublicKey)keyFactory.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("problem " + e.getMessage(), e);
        }
    }

    public static ECPrivateKey decodePrivateKey(String keyString) {
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(keyString.getBytes(StandardCharsets.UTF_8)));
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return (ECPrivateKey)keyFactory.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("problem " + e.getMessage(), e);
        }
    }
}

