/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils;

import java.math.BigInteger;
import org.apache.commons.lang3.Validate;

public class Math {
    public static long safeAbs(long number) {
        if (Long.MIN_VALUE == number) {
            return Long.MAX_VALUE;
        }
        return java.lang.Math.abs(number);
    }

    public static int safeAbs(int number) {
        if (Integer.MIN_VALUE == number) {
            return Integer.MAX_VALUE;
        }
        return java.lang.Math.abs(number);
    }

    public static long pow(long l, int exp) {
        BigInteger bi = BigInteger.valueOf(l).pow(exp);
        if (bi.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || bi.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new IllegalArgumentException("pow(" + l + "," + exp + ") exceeds Long.MAX_VALUE");
        }
        return bi.longValue();
    }

    public static double normalize(double i, double factor) {
        Validate.isTrue((i >= 0.0 ? 1 : 0) != 0, (String)"should be positive value", (Object[])new Object[0]);
        return (1.0 / (1.0 + java.lang.Math.exp(-1.0 * (factor * i))) - 0.5) * 2.0;
    }

    public static double round(double number, int decimals) {
        Validate.isTrue((number != 0.0 ? 1 : 0) != 0, (String)"should not be 0", (Object[])new Object[0]);
        Validate.isTrue((decimals != 0 ? 1 : 0) != 0, (String)"should not be 0", (Object[])new Object[0]);
        int temp = (int)(number * (double)Math.pow(10L, decimals));
        return (double)temp / (double)Math.pow(10L, decimals);
    }
}

