/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils;

import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.MDC;

public class MdcAware {
    public static Runnable wrap(Runnable task) {
        Map mdcMap = MDC.getCopyOfContextMap();
        return () -> {
            MDC.setContextMap((Map)mdcMap);
            task.run();
            MDC.clear();
        };
    }

    public static <T> Callable<T> wrap(Callable<T> task) {
        Map mdcMap = MDC.getCopyOfContextMap();
        return () -> {
            MDC.setContextMap((Map)mdcMap);
            Object result = task.call();
            MDC.clear();
            return result;
        };
    }
}

