/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.MDC;

public class MdcContext
implements AutoCloseable {
    private final List<String> keys = new ArrayList<String>();

    private MdcContext() {
    }

    public void put(String key, Object value) {
        if (key.contains(".")) {
            throw new IllegalArgumentException("no dots allowed in mdc keys");
        }
        if (value != null) {
            this.keys.add(key);
            MDC.put((String)key, (String)value.toString());
        }
    }

    @Override
    public void close() {
        for (String key : this.keys) {
            MDC.remove((String)key);
        }
    }

    public static void withContext(Consumer<MdcContext> block) {
        try (MdcContext ctx = MdcContext.create();){
            block.accept(ctx);
        }
    }

    public static MdcContext create() {
        return new MdcContext();
    }
}

