/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils;

import java.util.Optional;
import java.util.function.Function;

public class PatternEvaluator<Input, Output> {
    private final Pattern<Input, Output>[] patterns;

    @SafeVarargs
    public PatternEvaluator(Pattern<Input, Output> ... ps) {
        this.patterns = ps;
    }

    public Optional<Output> evaluate(Input matchVal) {
        for (Pattern<Input, Output> p : this.patterns) {
            if (!p.matches(matchVal)) continue;
            return p.apply(matchVal);
        }
        return Optional.empty();
    }

    public static <I, O> BoolExprPattern<I, O> matches(Function<I, Boolean> expr, Function<I, O> f) {
        return new BoolExprPattern<I, O>(expr, f);
    }

    public static <I, O> EqualsPattern<I, O> equals(I value, Function<I, O> f) {
        return new EqualsPattern<I, O>(value, f);
    }

    @SafeVarargs
    public static <I, O> PatternEvaluator<I, O> evaluator(Pattern<I, O> ... patterns) {
        return new PatternEvaluator<I, O>(patterns);
    }

    @SafeVarargs
    public static <I, O> Optional<O> evaluate(I input, Pattern<I, O> ... patterns) {
        return new PatternEvaluator<I, O>(patterns).evaluate(input);
    }

    public static class BoolExprPattern<I, O>
    implements Pattern<I, O> {
        private final Function<I, Boolean> evalFunction;
        private final Function<I, O> function;

        public BoolExprPattern(Function<I, Boolean> evalFunction, Function<I, O> function) {
            this.evalFunction = evalFunction;
            this.function = function;
        }

        @Override
        public boolean matches(I e) {
            return this.evalFunction.apply(e);
        }

        @Override
        public Optional<O> apply(I input) {
            return Optional.of(this.function.apply(input));
        }
    }

    public static class EqualsPattern<I, O>
    implements Pattern<I, O> {
        private final I val;
        private final Function<I, O> function;

        public EqualsPattern(I val, Function<I, O> function) {
            this.val = val;
            this.function = function;
        }

        @Override
        public boolean matches(I input) {
            return this.val.equals(input);
        }

        @Override
        public Optional<O> apply(I input) {
            return Optional.of(this.function.apply(input));
        }
    }

    static interface Pattern<I, O> {
        public boolean matches(I var1);

        public Optional<O> apply(I var1);
    }
}

