/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class ReInitializingReference<V>
implements Supplier<V> {
    private volatile V instance;
    private volatile long lastInitialized = 0L;
    private final Supplier<V> initializer;
    private final ReentrantLock lock = new ReentrantLock();
    private final long expirationInMillis;

    public ReInitializingReference(Supplier<V> supplier, long expiration, TimeUnit unit) {
        this.initializer = supplier;
        this.expirationInMillis = unit.toMillis(expiration);
    }

    @Override
    public V get() {
        if (this.needsReinitialization()) {
            this.lock.lock();
            try {
                if (this.needsReinitialization()) {
                    this.instance = this.initializer.get();
                    this.lastInitialized = System.currentTimeMillis();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.instance;
    }

    public void reset() {
        this.lock.lock();
        try {
            this.lastInitialized = 0L;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean needsReinitialization() {
        return this.instance == null || System.currentTimeMillis() - this.lastInitialized > this.expirationInMillis;
    }
}

