/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SimpleStringTrie {
    private final TrieNode root = new TrieNode();

    public static SimpleStringTrie from(Map<String, ?> map) {
        SimpleStringTrie st = new SimpleStringTrie();
        map.keySet().forEach(key -> st.add((String)key));
        return st;
    }

    public void add(String input) {
        TrieNode currentNode = this.root;
        for (char c : input.toCharArray()) {
            Map<Character, TrieNode> children = currentNode.getChildren();
            TrieNode matchingNode = children.get(Character.valueOf(c));
            if (matchingNode != null) {
                currentNode = matchingNode;
                continue;
            }
            TrieNode newNode = new TrieNode();
            children.put(Character.valueOf(c), newNode);
            currentNode = newNode;
        }
        currentNode.end = true;
    }

    public Optional<String> get(String input) {
        TrieNode currentNode = this.root;
        int i = 0;
        for (char c : input.toCharArray()) {
            TrieNode nextNode = currentNode.getChildren().get(Character.valueOf(c));
            if (nextNode != null) {
                ++i;
                currentNode = nextNode;
                continue;
            }
            if (i <= 0 || !currentNode.isLeaf()) continue;
            return Optional.of(input.substring(0, i));
        }
        if (i > 0 && currentNode.isLeaf()) {
            return Optional.of(input.substring(0, i));
        }
        return Optional.empty();
    }

    public List<String> match(String input) {
        return this.addMoreStrings(input, "", this.root);
    }

    private List<String> addMoreStrings(String input, String prefix, TrieNode currentNode) {
        int i = 0;
        ArrayList<String> results = new ArrayList<String>();
        for (char c : input.toCharArray()) {
            TrieNode nextNode = currentNode.getChildren().get(Character.valueOf(c));
            if (nextNode == null) continue;
            ++i;
            currentNode = nextNode;
        }
        String matched = input.substring(0, i);
        if (i > 0 && currentNode.isLeaf()) {
            results.add(prefix + matched);
        }
        if (!currentNode.equals(this.root) && i == input.length()) {
            results.addAll(currentNode.strings().map(s -> prefix + matched + s).collect(Collectors.toList()));
        }
        return results;
    }

    private static class TrieNode {
        private final Map<Character, TrieNode> children = new HashMap<Character, TrieNode>();
        boolean end = false;

        public Map<Character, TrieNode> getChildren() {
            return this.children;
        }

        public boolean isLeaf() {
            return this.end;
        }

        public Stream<String> strings() {
            return this.children.entrySet().stream().flatMap(entry -> {
                TrieNode n = (TrieNode)entry.getValue();
                if (n.isLeaf()) {
                    return Streams.concat((Stream[])new Stream[]{Stream.of("" + entry.getKey()), n.strings().map(s -> "" + entry.getKey() + s)});
                }
                return n.strings().map(s -> "" + entry.getKey() + s);
            });
        }
    }
}

