/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils.maps;

import io.inbot.utils.maps.DelegatingRichMap;
import io.inbot.utils.maps.DelegatingRichMultiMap;
import io.inbot.utils.maps.ImmutableMapEntry;
import io.inbot.utils.maps.RichMap;
import io.inbot.utils.maps.RichMultiMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class MapFactory {
    @SafeVarargs
    public static <K, V> Map<K, V> map(Map.Entry<K, V> ... entries) {
        return MapFactory.map(() -> new HashMap(), entries);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> map(Supplier<Map<K, V>> mapFactory, Map.Entry<K, V> ... entries) {
        Map<K, V> newMap = mapFactory.get();
        for (Map.Entry<K, V> entry : entries) {
            newMap.put(entry.getKey(), entry.getValue());
        }
        return newMap;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new ImmutableMapEntry<K, V>(key, value);
    }

    public static <K, V> RichMap<K, V> richMap(Map<K, V> existing) {
        return new DelegatingRichMap<K, V>(existing);
    }

    @SafeVarargs
    public static <K, V> RichMap<K, V> richMap(Map<K, V> existing, Map.Entry<K, V> ... entries) {
        DelegatingRichMap<K, V> newMap = new DelegatingRichMap<K, V>(existing);
        newMap.put(entries);
        return newMap;
    }

    @SafeVarargs
    public static <K, V> RichMap<K, V> richMap(Map.Entry<K, V> ... entries) {
        DelegatingRichMap<K, V> newMap = new DelegatingRichMap<K, V>(new HashMap());
        newMap.put(entries);
        return newMap;
    }

    public static <K, V> RichMultiMap<K, V> multiMap() {
        return new DelegatingRichMultiMap();
    }
}

