/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.utils.maps;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public interface RichMap<K, V>
extends Map<K, V> {
    default public void put(Map.Entry<K, V> ... es) {
        for (Map.Entry<K, V> e : es) {
            this.put(e.getKey(), e.getValue());
        }
    }

    default public Optional<V> maybeGet(K key) {
        return Optional.ofNullable(this.get(key));
    }

    @Override
    default public boolean put(K key, Optional<V> value) {
        if (value.isPresent()) {
            this.put(key, value.get());
            return true;
        }
        return false;
    }

    default public V getOrCreate(K key, Supplier<V> supplier) {
        Optional<V> maybeExists = this.maybeGet(key);
        if (maybeExists.isPresent()) {
            return maybeExists.get();
        }
        V newValue = supplier.get();
        this.put(key, newValue);
        return newValue;
    }
}

