/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.xmltools;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.inbot.xmltools.exceptions.RethrownException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PooledXmlParser {
    private LoadingCache<Long, DocumentBuilder> documentBuilderPool;

    public PooledXmlParser(int threads, int expirationMinutes) {
        this(threads, expirationMinutes, () -> {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setValidating(false);
                DocumentBuilder builder = dbf.newDocumentBuilder();
                return builder;
            }
            catch (ParserConfigurationException e) {
                throw RethrownException.rethrow(e);
            }
        });
    }

    public PooledXmlParser(int threads, int expirationMinutes, final Supplier<DocumentBuilder> dbSupplier) {
        this.documentBuilderPool = CacheBuilder.newBuilder().maximumSize((long)threads).build((CacheLoader)new CacheLoader<Long, DocumentBuilder>(){

            public DocumentBuilder load(Long id) throws Exception {
                return (DocumentBuilder)dbSupplier.get();
            }
        });
    }

    public Document parseXml(Reader r) {
        return this.parse(new InputSource(r));
    }

    public Document parseXml(InputStream inputStream, Charset encoding) {
        return this.parseXml(new BufferedReader(new InputStreamReader(inputStream, encoding)));
    }

    public Document parseXml(String xmlBuffer) {
        return this.parseXml(new ByteArrayInputStream(xmlBuffer.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public Document parse(InputSource inputSource) {
        try {
            return this.getDocumentBuilderForCurrentThread().parse(inputSource);
        }
        catch (IOException | SAXException e) {
            throw RethrownException.rethrow(e);
        }
    }

    public DocumentBuilder getDocumentBuilderForCurrentThread() {
        try {
            return (DocumentBuilder)this.documentBuilderPool.get((Object)Thread.currentThread().getId());
        }
        catch (ExecutionException e) {
            throw RethrownException.rethrow(e.getCause());
        }
    }
}

