/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.xmltools;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class ValidXMLCharacterFilterReader
extends FilterReader {
    public ValidXMLCharacterFilterReader(Reader in) {
        super(in);
    }

    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        int c;
        int length = len;
        int offSet = off;
        if (length <= 0) {
            return 0;
        }
        int start = offSet;
        while (length > 0 && (c = this.in.read()) != -1) {
            if (!ValidXMLCharacterFilterReader.isAllowedInXml(c)) continue;
            buf[offSet++] = (char)c;
            --length;
        }
        int count = offSet - start;
        return count > 0 ? count : -1;
    }

    public static boolean isAllowedInXml(int c) {
        boolean ok = false;
        if (c >= 65536 && c <= 0x10FFFF) {
            ok = true;
        } else if (c >= 57344 && c <= 65533) {
            ok = true;
        } else if (c >= 32 && c <= 55295) {
            ok = true;
        } else if (c == 9 || c == 10 || c == 13) {
            ok = true;
        }
        return ok;
    }
}

