/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.xmltools;

import io.inbot.xmltools.XPathExpressionCache;
import io.inbot.xmltools.exceptions.RethrownException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathBrowser {
    private final Node rootNode;
    private final XPathExpressionCache expressionCache;

    XPathBrowser(XPathExpressionCache expressionCache, Node node) {
        this.expressionCache = expressionCache;
        this.rootNode = node;
    }

    public Object eval(String expr, Node node, QName resultType) {
        try {
            return this.expressionCache.getExpression(expr).evaluate(node, resultType);
        }
        catch (XPathExpressionException e) {
            throw RethrownException.rethrow(e);
        }
    }

    public boolean getBoolean(Node n, String expr) {
        return this.getString(n, expr).map(s -> Boolean.valueOf(s)).orElse(false);
    }

    public boolean getBoolean(String expr) {
        return this.getBoolean(this.node(), expr);
    }

    public boolean getBoolean() {
        return this.getBoolean(".");
    }

    public Optional<Double> getDouble(Node n, String expr) {
        return this.getString(n, expr).map(s -> Double.valueOf(s));
    }

    public Optional<Double> getDouble(String expr) {
        return this.getDouble(this.node(), expr);
    }

    public Optional<Double> getDouble() {
        return this.getDouble(".");
    }

    public Optional<Integer> getInt(Node n, String expr) {
        return this.getString(n, expr).map(s -> Integer.valueOf(s));
    }

    public Optional<Integer> getInt(String expr) {
        return this.getInt(this.node(), expr);
    }

    public Optional<Integer> getInt() {
        return this.getInt(".");
    }

    public Optional<Number> getNumber(Locale locale, String expr) {
        return this.getNumber(locale, this.rootNode, expr);
    }

    public Optional<Number> getNumber(Locale locale, Node n, String expr) {
        return this.getString(n, expr).map(s -> {
            try {
                return NumberFormat.getInstance(locale).parse((String)s);
            }
            catch (ParseException e) {
                throw RethrownException.rethrow(e);
            }
        });
    }

    public Optional<BigDecimal> getBigDecimal(Locale locale, String expr) {
        return this.getBigDecimal(locale, this.rootNode, expr);
    }

    public Optional<BigDecimal> getBigDecimal(Locale locale, Node n, String expr) {
        return this.getString(n, expr).map(s -> {
            DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance(locale);
            nf.setParseBigDecimal(true);
            return (BigDecimal)nf.parse((String)s, new ParsePosition(0));
        });
    }

    public Optional<BigInteger> getBigInteger(String expr) {
        return this.getBigInteger(this.rootNode, expr);
    }

    public Optional<BigInteger> getBigInteger(Node n, String expr) {
        return this.getString(n, expr).map(s -> new BigInteger((String)s));
    }

    public Optional<Long> getLong(Node n, String expr) {
        return this.getString(n, expr).map(s -> Long.valueOf(s));
    }

    public Optional<Long> getLong(String expr) {
        return this.getLong(this.node(), expr);
    }

    public Optional<Long> getLong() {
        return this.getLong(".");
    }

    public Optional<String> getString(Node n, String expr) {
        String result = ((String)this.eval(expr, n, XPathConstants.STRING)).trim();
        if (StringUtils.isBlank((CharSequence)result)) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public Optional<String> getString(String expr) {
        String s = ((String)this.eval(expr, this.node(), XPathConstants.STRING)).trim();
        if (StringUtils.isBlank((CharSequence)s)) {
            return Optional.empty();
        }
        return Optional.of(s);
    }

    public Optional<String> getString() {
        return this.getString(".");
    }

    public Optional<Node> getFirstNode(String expr) {
        return this.getFirstNode(this.node(), expr);
    }

    public Optional<Node> getFirstNode(Node n, String expr) {
        NodeList nodeList = this.getNodeList(n, expr);
        if (nodeList.getLength() == 0) {
            return Optional.empty();
        }
        return Optional.of(nodeList.item(0));
    }

    public NodeList getNodeList(Node n, String expr) {
        return (NodeList)this.eval(expr, n, XPathConstants.NODESET);
    }

    public NodeList getNodeList(String expr) {
        return (NodeList)this.eval(expr, this.node(), XPathConstants.NODESET);
    }

    public String[] getStringValues(Node n, String expr) {
        NodeList nodes = this.getNodeList(n, expr);
        String[] values = new String[nodes.getLength()];
        for (int i = 0; i < nodes.getLength(); ++i) {
            values[i] = this.getString(nodes.item(i), ".").orElse("");
        }
        return values;
    }

    public String[] getStringValues(String expr) {
        return this.getStringValues(this.node(), expr);
    }

    public Node getSubNode(Node parent, String name) {
        Node node = (Node)this.eval(name, parent, XPathConstants.NODE);
        return node;
    }

    public Node node() {
        return this.rootNode;
    }

    public Optional<String> getNodeAttribute(String key) {
        return this.getString("@" + key);
    }

    public Map<String, String> nodeAttributes() {
        NamedNodeMap attributes = this.rootNode.getAttributes();
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (attributes != null) {
            attributes.getLength();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attributeNode = attributes.item(i);
                map.put(attributeNode.getNodeName(), this.getString(attributeNode, ".").get());
            }
        }
        return map;
    }

    public XPathBrowser browse(Node node) {
        return new XPathBrowser(this.expressionCache, node);
    }

    public XPathBrowser browseFirst(String expression) {
        return new XPathBrowser(this.expressionCache, this.getFirstNode(expression).orElseThrow(() -> new NoSuchElementException("node does not exist for " + expression)));
    }

    public Stream<XPathBrowser> streamSubNodes() {
        return StreamSupport.stream(this.browseSubNodes().spliterator(), false);
    }

    public Stream<XPathBrowser> streamMatching(String expr) {
        return StreamSupport.stream(this.browseMatching(expr).spliterator(), false);
    }

    public Iterable<XPathBrowser> browseSubNodes() {
        return this.browseMatching("./*");
    }

    public Iterable<XPathBrowser> browseMatching(String expr) {
        final NodeList nodeList = this.getNodeList(this.node(), expr);
        final XPathBrowser parent = this;
        return new Iterable<XPathBrowser>(){

            @Override
            public Iterator<XPathBrowser> iterator() {
                return new NodeIterator(nodeList, parent);
            }
        };
    }

    public Iterator<XPathBrowser> browseMatching(Node n, String expr) {
        NodeList nodeList = this.getNodeList(n, expr);
        return new NodeIterator(nodeList, this);
    }

    private final class NodeIterator
    implements Iterator<XPathBrowser> {
        private final NodeList nodeList;
        int i = 0;

        private NodeIterator(NodeList nodeList, XPathBrowser browser) {
            this.nodeList = nodeList;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.i < this.nodeList.getLength();
            return hasNext;
        }

        @Override
        public XPathBrowser next() {
            return new XPathBrowser(XPathBrowser.this.expressionCache, this.nodeList.item(this.i++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }
}

