/*
 * Decompiled with CFR 0.152.
 */
package io.inbot.xmltools;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

public class XPathExpressionCache {
    private final LoadingCache<Long, Cache<String, XPathExpression>> perThreadCaches;
    private final XPath xpath;

    public XPathExpressionCache(int threadCacheSize, int threadCacheExpireMinutes, final int cacheSize, final int evictionOfUnusedInMinutes) {
        this.perThreadCaches = CacheBuilder.newBuilder().maximumSize((long)threadCacheSize).expireAfterAccess((long)threadCacheExpireMinutes, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, Cache<String, XPathExpression>>(){

            public Cache<String, XPathExpression> load(Long id) throws Exception {
                return CacheBuilder.newBuilder().maximumSize((long)cacheSize).expireAfterAccess((long)evictionOfUnusedInMinutes, TimeUnit.MINUTES).build();
            }
        });
        XPathFactory xpf = XPathFactory.newInstance();
        this.xpath = xpf.newXPath();
        this.xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return "http://domain.com/" + prefix;
            }

            public Iterator getPrefixes(String val) {
                return null;
            }

            @Override
            public String getPrefix(String uri) {
                return null;
            }
        });
    }

    public XPathExpression getExpression(String expression) throws XPathExpressionException {
        try {
            return (XPathExpression)((Cache)this.perThreadCaches.get((Object)Thread.currentThread().getId())).get((Object)expression, () -> this.xpath.compile(expression));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof XPathExpressionException) {
                throw (XPathExpressionException)e.getCause();
            }
            throw new IllegalStateException(e.getCause());
        }
    }
}

