/*
 * Decompiled with CFR 0.152.
 */
package io.innerloop.neo4j.client;

import java.util.List;

public class RowSet {
    private final String[] columnNames;
    private final List<Object[]> rows;
    private final int totalRows;
    private int currentRow;

    public RowSet(String[] columnNames, List<Object[]> rows) {
        this.columnNames = columnNames;
        this.rows = rows;
        this.totalRows = this.rows.size();
        this.currentRow = 0;
    }

    public boolean hasNext() {
        return this.totalRows > this.currentRow;
    }

    public Object[] next() {
        return this.rows.get(this.currentRow++);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getString(int column) {
        return (String)this.getRow(this.currentRow)[column];
    }

    public int getInt(int column) {
        return (Integer)this.getRow(this.currentRow)[column];
    }

    public long getLong(int column) {
        return ((Number)this.getRow(this.currentRow)[column]).longValue();
    }

    public float getFloat(int column) {
        return ((Float)this.getRow(this.currentRow)[column]).floatValue();
    }

    public double getDouble(int column) {
        return (Double)this.getRow(this.currentRow)[column];
    }

    public boolean getBoolean(int column) {
        return (Boolean)this.getRow(this.currentRow)[column];
    }

    public short getShort(int column) {
        return (Short)this.getRow(this.currentRow)[column];
    }

    public byte getByte(int column) {
        return (Byte)this.getRow(this.currentRow)[column];
    }

    public char getChar(int column) {
        return ((Character)this.getRow(this.currentRow)[column]).charValue();
    }

    private Object[] getRow(int index) {
        return this.rows.get(index);
    }
}

