/*
 * Decompiled with CFR 0.152.
 */
package io.innerloop.neo4j.client;

import io.innerloop.neo4j.client.spi.impl.rest.json.JSONArray;
import io.innerloop.neo4j.client.spi.impl.rest.json.JSONObject;
import java.util.HashMap;
import java.util.Map;

public abstract class Statement {
    protected final String statement;
    protected final Map<String, Object> parameters;
    private final String[] resultDataContents;
    protected boolean includeStats;

    public Statement(String query) {
        this.statement = query;
        this.parameters = new HashMap<String, Object>();
        this.includeStats = false;
        this.resultDataContents = new String[]{this.getType()};
    }

    public String getQuery() {
        return this.statement;
    }

    public void setParam(String key, Object value) {
        this.parameters.put(key, value);
    }

    public abstract String getType();

    public JSONObject toJson() {
        return new JSONObject().put("statement", this.statement).put("resultDataContents", new JSONArray(this.resultDataContents)).put("includeStats", this.includeStats).put("parameters", new JSONObject(this.parameters));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Statement)) {
            return false;
        }
        Statement s = (Statement)o;
        return s.statement.equals(this.statement) && s.parameters.equals(this.parameters) && s.resultDataContents[0].equals(this.resultDataContents[0]);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.statement.hashCode();
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + this.resultDataContents[0].hashCode();
        return result;
    }
}

