/*
 * Decompiled with CFR 0.152.
 */
package io.innerloop.neo4j.client.spi.impl.rest;

import io.innerloop.neo4j.client.Connection;
import io.innerloop.neo4j.client.Graph;
import io.innerloop.neo4j.client.GraphStatement;
import io.innerloop.neo4j.client.Neo4jClientException;
import io.innerloop.neo4j.client.Neo4jServerException;
import io.innerloop.neo4j.client.Neo4jServerMultiException;
import io.innerloop.neo4j.client.RowSet;
import io.innerloop.neo4j.client.RowStatement;
import io.innerloop.neo4j.client.Statement;
import io.innerloop.neo4j.client.spi.impl.rest.ExecutionResult;
import io.innerloop.neo4j.client.spi.impl.rest.http.HttpClient;
import io.innerloop.neo4j.client.spi.impl.rest.json.JSONException;
import io.innerloop.neo4j.client.spi.impl.rest.json.JSONObject;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestConnectionImpl
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(RestConnectionImpl.class);
    private final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss Z").withLocale(Locale.ENGLISH);
    private static ThreadLocal<RestConnectionImpl> connectionHolder = new ThreadLocal();
    private final HttpClient client;
    private List<Statement> statements;
    private String activeTransactionEndpointUrl;
    private OffsetDateTime transactionExpires;

    public static Connection getConnection(HttpClient client, String transactionEndpointUrl) {
        RestConnectionImpl connection = connectionHolder.get();
        if (connection == null) {
            LOG.debug("Getting new Connection for Thread: [{}]", (Object)Thread.currentThread().getName());
            connection = new RestConnectionImpl(client, transactionEndpointUrl);
            connectionHolder.set(connection);
        }
        return connection;
    }

    public static void closeConnection() {
        connectionHolder.remove();
    }

    public RestConnectionImpl(HttpClient client, String transactionEndpointUrl) {
        this.activeTransactionEndpointUrl = transactionEndpointUrl;
        this.statements = new ArrayList<Statement>();
        this.client = client;
    }

    @Override
    public void add(Statement statement) {
        this.statements.add(statement);
    }

    @Override
    public List<Statement> getStatements() {
        return this.statements;
    }

    @Override
    public OffsetDateTime getExpiry() {
        return this.transactionExpires;
    }

    @Override
    public void flush() {
        try {
            LOG.debug("Flushing to [{}]", (Object)this.activeTransactionEndpointUrl);
            JSONObject jsonResult = this.execute(this.activeTransactionEndpointUrl);
            this.activeTransactionEndpointUrl = jsonResult.getString("commit").replace("/commit", "");
            this.transactionExpires = OffsetDateTime.parse(jsonResult.getJSONObject("transaction").getString("expires"), this.FORMATTER);
            this.statements.clear();
            LOG.debug("Next endpoint is now: [{}] which expires at: [{}]", (Object)this.activeTransactionEndpointUrl, (Object)this.transactionExpires);
        }
        catch (IOException e) {
            this.close();
            throw new Neo4jClientException(e);
        }
        catch (JSONException e) {
            this.close();
            throw new Neo4jClientException("Error when processing JSON response.", e);
        }
    }

    @Override
    public void commit() {
        try {
            String commitEndpoint = this.activeTransactionEndpointUrl + "/commit";
            LOG.debug("Committing to [{}]", (Object)commitEndpoint);
            this.execute(commitEndpoint);
        }
        catch (Exception e) {
            throw new Neo4jClientException("Encountered an error when trying to commit to Neo4J. See exception for details.", e);
        }
        finally {
            LOG.debug("Closing connection.");
            this.close();
        }
    }

    @Override
    public void resetExpiry() {
        try {
            JSONObject payload = new JSONObject().put("statements", (Object)new ArrayList());
            LOG.info("Executing [{}] statements.", (Object)this.statements.size());
            LOG.debug("Statements are: [{}]", (Object)payload.toString());
            String result = this.client.post(this.activeTransactionEndpointUrl, payload);
            LOG.debug("Raw result is: [{}]", (Object)result);
            JSONObject jsonResult = new JSONObject(result);
            ExecutionResult er = new ExecutionResult(jsonResult);
            this.checkErrors(er.getErrors());
            this.activeTransactionEndpointUrl = jsonResult.getString("commit").replace("/commit", "");
            this.transactionExpires = OffsetDateTime.parse(jsonResult.getJSONObject("transaction").getString("expires"), this.FORMATTER);
        }
        catch (Exception e) {
            this.close();
            throw new Neo4jClientException(e);
        }
    }

    private JSONObject execute(String endpointUrl) throws IOException {
        List statements = this.statements.stream().map(Statement::toJson).collect(Collectors.toList());
        JSONObject payload = new JSONObject().put("statements", (Object)statements);
        LOG.info("Executing [{}] statements.", (Object)statements.size());
        LOG.debug("Statements are: [{}]", (Object)payload.toString());
        String result = this.client.post(endpointUrl, payload);
        LOG.debug("Raw result is: [{}]", (Object)result);
        JSONObject jsonResult = new JSONObject(result);
        ExecutionResult er = new ExecutionResult(jsonResult);
        this.checkErrors(er.getErrors());
        for (int i = 0; i < this.statements.size(); ++i) {
            Statement statement = this.statements.get(i);
            JSONObject jsonObject = er.geResult(i);
            if (statement.getType().equals("row")) {
                RowSet rs = er.buildRowSet(jsonObject);
                ((RowStatement)statement).setResult(rs);
                continue;
            }
            Graph g = er.buildGraph(jsonObject);
            ((GraphStatement)statement).setResult(g);
        }
        return jsonResult;
    }

    @Override
    public void rollback() {
        try {
            String json = this.client.delete(this.activeTransactionEndpointUrl);
            ExecutionResult er = new ExecutionResult(new JSONObject(json));
            this.checkErrors(er.getErrors());
        }
        catch (Exception e) {
            this.close();
            throw new Neo4jClientException(e);
        }
    }

    private void close() {
        RestConnectionImpl.closeConnection();
    }

    void checkErrors(Neo4jServerException[] exceptions) {
        int length = exceptions.length;
        if (length == 1) {
            throw exceptions[0];
        }
        if (length > 1) {
            throw new Neo4jServerMultiException("Multiple errors occurred when executing statements", exceptions);
        }
    }
}

