/*
 * Decompiled with CFR 0.152.
 */
package io.innerloop.neo4j.client.spi.impl.rest.http;

import io.innerloop.neo4j.client.spi.impl.rest.http.Message;
import io.innerloop.neo4j.client.spi.impl.rest.http.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Request
extends Message<Request> {
    private HttpURLConnection connection;
    private OutputStreamWriter writer;
    private URL url;
    private Map<String, String> query = new HashMap<String, String>();

    public Request(String url) throws IOException {
        this.url = new URL(url);
        this.connection = (HttpURLConnection)this.url.openConnection();
    }

    public Request addQueryParameter(String name, String value) {
        this.query.put(name, value);
        return this;
    }

    public Request removeQueryParameter(String name) {
        this.query.remove(name);
        return this;
    }

    public Response getResource() throws IOException {
        return this.actionResponse("GET");
    }

    private Response actionResponse(String get) throws IOException {
        this.buildQueryString();
        this.buildHeaders();
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod(get);
        return this.readResponse();
    }

    public Response putResource() throws IOException {
        return this.writeResource("PUT", this.body);
    }

    public Response postResource() throws IOException {
        return this.writeResource("POST", this.body);
    }

    public Response deleteResource() throws IOException {
        return this.actionResponse("DELETE");
    }

    private Response writeResource(String method, String body) throws IOException {
        this.buildQueryString();
        this.buildHeaders();
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod(method);
        this.writer = new OutputStreamWriter(this.connection.getOutputStream());
        this.writer.write(body);
        this.writer.flush();
        this.writer.close();
        return this.readResponse();
    }

    private Response readResponse() throws IOException {
        String line;
        this.connection.getResponseCode();
        InputStream stream = this.connection.getErrorStream();
        if (stream == null) {
            stream = this.connection.getInputStream();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        reader.close();
        return (Response)((Response)new Response().setResponseCode(this.connection.getResponseCode()).setResponseMessage(this.connection.getResponseMessage()).setHeaders(this.connection.getHeaderFields())).setBody(builder.toString());
    }

    private void buildQueryString() throws MalformedURLException {
        StringBuilder builder = new StringBuilder();
        if (!this.query.isEmpty()) {
            for (Map.Entry<String, String> param : this.query.entrySet()) {
                builder.append((Object)param.getKey());
                builder.append("=");
                builder.append((Object)param.getValue());
                builder.append("&");
            }
            builder.deleteCharAt(builder.lastIndexOf("&"));
        }
        if (builder.length() > 0) {
            builder.insert(0, "?");
        }
        this.url = new URL(this.url.toString() + builder.toString());
    }

    private void buildHeaders() {
        if (!this.headers.isEmpty()) {
            for (Map.Entry entry : this.headers.entrySet()) {
                List values = (List)entry.getValue();
                for (String value : values) {
                    this.connection.addRequestProperty((String)entry.getKey(), value);
                }
            }
        }
    }
}

