/*
 * Decompiled with CFR 0.152.
 */
package io.innerloop.neo4j.ogm.spring.repository;

import io.innerloop.neo4j.ogm.SessionFactory;
import io.innerloop.neo4j.ogm.spring.repository.GenericRepository;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRED)
public abstract class DefaultNeo4jRepositoryImpl<T>
implements GenericRepository<T> {
    protected final SessionFactory sessionFactory;
    private Class<T> persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    @Autowired
    public DefaultNeo4jRepositoryImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected Class<T> getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public Iterable<T> findAll() {
        return this.sessionFactory.getCurrentSession().loadAll(this.getPersistentClass());
    }

    @Override
    public T findBy(Map<String, Object> parameters) {
        return (T)this.sessionFactory.getCurrentSession().load(this.getPersistentClass(), parameters);
    }

    @Override
    public T findBy(String propertyName, Object propertyValue) {
        return (T)this.sessionFactory.getCurrentSession().load(this.getPersistentClass(), propertyName, propertyValue);
    }

    @Override
    public void save(T entity) {
        this.sessionFactory.getCurrentSession().save(entity);
    }

    @Override
    public void delete(T entity) {
        this.sessionFactory.getCurrentSession().delete(entity);
    }
}

