/*
 * Decompiled with CFR 0.152.
 */
package io.innerloop.neo4j.ogm.spring.transaction;

import io.innerloop.neo4j.ogm.Session;
import io.innerloop.neo4j.ogm.SessionFactory;
import io.innerloop.neo4j.ogm.Transaction;
import io.innerloop.neo4j.ogm.spring.transaction.SessionHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class Neo4jTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    private SessionFactory sessionFactory;

    public Neo4jTransactionManager() {
        this.setGlobalRollbackOnParticipationFailure(false);
    }

    public Neo4jTransactionManager(SessionFactory sessionFactory) {
        this();
        this.sessionFactory = sessionFactory;
        this.afterPropertiesSet();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected Object doGetTransaction() throws TransactionException {
        this.logger.info((Object)"Requesting to create or join a transaction");
        Neo4jTransactionObject txObject = new Neo4jTransactionObject();
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory()));
        if (sessionHolder != null) {
            txObject.setSessionHolder(sessionHolder, false);
        }
        return txObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        Neo4jTransactionObject txObject = (Neo4jTransactionObject)transaction;
        Session session = null;
        try {
            if (txObject.getSessionHolder() == null || txObject.getSessionHolder().isSynchronizedWithTransaction()) {
                Session newSession = this.getSessionFactory().getCurrentSession();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Acquired Session [" + newSession + "] for Neo4j OGM transaction"));
                }
                txObject.setSessionHolder(new SessionHolder(newSession), true);
            }
            txObject.getSessionHolder().setSynchronizedWithTransaction(true);
            session = txObject.getSessionHolder().getSession();
            Transaction neo4jTransaction = session.getTransaction();
            neo4jTransaction.begin();
            txObject.getSessionHolder().setTransaction(neo4jTransaction);
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.getSessionFactory(), (Object)((Object)txObject.getSessionHolder()));
            }
        }
        catch (Throwable ex) {
            if (txObject.isNewSessionHolder()) {
                try {
                    if (session != null && session.getTransaction().isOpen()) {
                        session.getTransaction().rollback();
                    }
                }
                finally {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable ex2) {
                            this.logger.debug((Object)"Unexpected exception on closing Neo4j OGM Session", ex2);
                        }
                    }
                    txObject.setSessionHolder(null, false);
                }
            }
            throw new CannotCreateTransactionException("Could not open OGM Session for transaction", ex);
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        Neo4jTransactionObject txObject = (Neo4jTransactionObject)status.getTransaction();
        Session session = txObject.getSessionHolder().getSession();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing Neo4j OGM transaction on Session [" + session + "]"));
        }
        session.getTransaction().commit();
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        Neo4jTransactionObject txObject = (Neo4jTransactionObject)transaction;
        return txObject.getSessionHolder() != null && txObject.getSessionHolder().getTransaction().isActive();
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        status.setRollbackOnly();
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        Neo4jTransactionObject txObject = (Neo4jTransactionObject)status.getTransaction();
        Session session = txObject.getSessionHolder().getSession();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back Neo4j OGM transaction on Session [" + session + "]"));
        }
        session.getTransaction().rollback();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        Neo4jTransactionObject txObject = (Neo4jTransactionObject)transaction;
        if (txObject.isNewSessionHolder()) {
            TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
        }
        Session session = txObject.getSessionHolder().getSession();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Closing Neo4j OGM Session [" + session + "] after transaction"));
        }
        if (session != null) {
            session.close();
        }
        txObject.getSessionHolder().clear();
    }

    public void afterPropertiesSet() {
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("Property 'sessionFactory' is required");
        }
    }

    public Object getResourceFactory() {
        return this.getSessionFactory();
    }

    private class Neo4jTransactionObject
    implements SmartTransactionObject {
        private SessionHolder sessionHolder;
        private boolean newSessionHolder;

        private Neo4jTransactionObject() {
        }

        public void setSession(Session session) {
            this.sessionHolder = new SessionHolder(session);
            this.newSessionHolder = true;
        }

        public void setExistingSession(Session session) {
            this.sessionHolder = new SessionHolder(session);
            this.newSessionHolder = true;
        }

        public void setSessionHolder(SessionHolder sessionHolder, boolean newConnectionHolder) {
            this.sessionHolder = sessionHolder;
            this.newSessionHolder = newConnectionHolder;
        }

        public SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        public boolean isNewSessionHolder() {
            return this.newSessionHolder;
        }

        public void setRollbackOnly() {
            this.sessionHolder.setRollbackOnly();
        }

        public boolean isRollbackOnly() {
            return this.sessionHolder.isRollbackOnly();
        }

        public void flush() {
            this.sessionHolder.getSession().flush();
        }
    }
}

