/*
 * Decompiled with CFR 0.152.
 */
package org.koin.compose.application;

import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.KoinApplication;
import org.koin.core.annotation.KoinInternalApi;
import org.koin.core.context.DefaultContextExtKt;
import org.koin.mp.KoinPlatform;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/koin/compose/application/CompositionKoinApplicationLoader;", "Landroidx/compose/runtime/RememberObserver;", "koinApplication", "Lorg/koin/core/KoinApplication;", "<init>", "(Lorg/koin/core/KoinApplication;)V", "getKoinApplication", "()Lorg/koin/core/KoinApplication;", "koin", "Lorg/koin/core/Koin;", "getKoin", "()Lorg/koin/core/Koin;", "setKoin", "(Lorg/koin/core/Koin;)V", "onAbandoned", "", "onForgotten", "onRemembered", "start", "stop", "koin-compose_release"})
@KoinInternalApi
@StabilityInferred(parameters=0)
public final class CompositionKoinApplicationLoader
implements RememberObserver {
    @NotNull
    private final KoinApplication koinApplication;
    @Nullable
    private Koin koin;
    public static final int $stable = 8;

    public CompositionKoinApplicationLoader(@NotNull KoinApplication koinApplication) {
        Intrinsics.checkNotNullParameter((Object)koinApplication, (String)"koinApplication");
        this.koinApplication = koinApplication;
        this.start();
    }

    @NotNull
    public final KoinApplication getKoinApplication() {
        return this.koinApplication;
    }

    @Nullable
    public final Koin getKoin() {
        return this.koin;
    }

    public final void setKoin(@Nullable Koin koin) {
        this.koin = koin;
    }

    public void onAbandoned() {
        this.stop();
    }

    public void onForgotten() {
        this.stop();
    }

    public void onRemembered() {
        this.start();
    }

    private final void start() {
        if (KoinPlatform.INSTANCE.getKoinOrNull() == null) {
            try {
                Koin koin = this.koin = DefaultContextExtKt.startKoin((KoinApplication)this.koinApplication).getKoin();
                Intrinsics.checkNotNull((Object)koin);
                koin.getLogger().debug(this + " -> attach Koin instance " + this.koin);
            }
            catch (Exception e) {
                throw new IllegalStateException(("Can't start Koin from Compose context - " + e).toString());
            }
        } else {
            Koin koin = this.koin = KoinPlatform.INSTANCE.getKoin();
            Intrinsics.checkNotNull((Object)koin);
            koin.getLogger().debug(this + " -> re-attach Koin instance " + this.koin);
        }
    }

    private final void stop() {
        this.koin = null;
        Koin koin = KoinPlatform.INSTANCE.getKoinOrNull();
        if (koin != null && (koin = koin.getLogger()) != null) {
            koin.debug(this + " -> stop Koin Application " + this.koinApplication);
        }
        DefaultContextExtKt.stopKoin();
    }
}

