/*
 * Decompiled with CFR 0.152.
 */
package org.koin.compiler;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.symbol.KSAnnotated;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.koin.compiler.generator.KoinCodeGenerator;
import org.koin.compiler.metadata.KoinMetaData;
import org.koin.compiler.metadata.KoinTagWriter;
import org.koin.compiler.scanner.KoinMetaDataScanner;
import org.koin.compiler.scanner.KoinTagMetaDataScanner;
import org.koin.compiler.verify.KoinConfigChecker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\fH\u0002J\b\u0010\u0019\u001a\u00020\fH\u0002J\b\u0010\u001a\u001a\u00020\fH\u0002J\b\u0010\u001b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/koin/compiler/BuilderProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "options", "", "", "<init>", "(Lcom/google/devtools/ksp/processing/CodeGenerator;Lcom/google/devtools/ksp/processing/KSPLogger;Ljava/util/Map;)V", "isViewModelMPActive", "", "koinCodeGenerator", "Lorg/koin/compiler/generator/KoinCodeGenerator;", "koinMetaDataScanner", "Lorg/koin/compiler/scanner/KoinMetaDataScanner;", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "initComponents", "", "isConfigCheckActive", "isKoinViewModelMPActive", "isDefaultModuleActive", "doLogTimes", "koin-ksp-compiler"})
public final class BuilderProcessor
implements SymbolProcessor {
    @NotNull
    private final CodeGenerator codeGenerator;
    @NotNull
    private final KSPLogger logger;
    @NotNull
    private final Map<String, String> options;
    private final boolean isViewModelMPActive;
    @NotNull
    private final KoinCodeGenerator koinCodeGenerator;
    @NotNull
    private final KoinMetaDataScanner koinMetaDataScanner;

    public BuilderProcessor(@NotNull CodeGenerator codeGenerator, @NotNull KSPLogger logger, @NotNull Map<String, String> options) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.codeGenerator = codeGenerator;
        this.logger = logger;
        this.options = options;
        this.isViewModelMPActive = this.isKoinViewModelMPActive();
        this.koinCodeGenerator = new KoinCodeGenerator(this.codeGenerator, this.logger, this.isViewModelMPActive);
        this.koinMetaDataScanner = new KoinMetaDataScanner(this.logger);
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        this.initComponents(resolver);
        boolean doLogTimes = this.doLogTimes();
        TimeSource.Monotonic.ValueTimeMark mainTime = doLogTimes ? TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()) : null;
        KSPLogger.logging$default((KSPLogger)this.logger, (String)"Scan symbols ...", null, (int)2, null);
        List<KSAnnotated> invalidSymbols = this.koinMetaDataScanner.findInvalidSymbols(resolver);
        if (!((Collection)invalidSymbols).isEmpty()) {
            KSPLogger.logging$default((KSPLogger)this.logger, (String)("Invalid symbols found (" + invalidSymbols.size() + "), waiting for next round"), null, (int)2, null);
            return invalidSymbols;
        }
        KoinMetaData.Module defaultModule = new KoinMetaData.Module("", "defaultModule", null, null, null, null, null, null, null, true, false, false, 3580, null);
        KSPLogger.logging$default((KSPLogger)this.logger, (String)"Build metadata ...", null, (int)2, null);
        List<KoinMetaData.Module> moduleList = this.koinMetaDataScanner.scanKoinModules(defaultModule, resolver);
        KSPLogger.logging$default((KSPLogger)this.logger, (String)"Generate code ...", null, (int)2, null);
        this.koinCodeGenerator.generateModules(moduleList, defaultModule, this.isDefaultModuleActive());
        boolean isConfigCheckActive = this.isConfigCheckActive();
        new KoinTagWriter(this.codeGenerator, this.logger, resolver, isConfigCheckActive).writeAllTags(moduleList, defaultModule);
        if (doLogTimes && mainTime != null) {
            TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mainTime.unbox-impl());
            KSPLogger.warn$default((KSPLogger)this.logger, (String)("Koin Configuration Generated in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mainTime.unbox-impl()))), null, (int)2, null);
        }
        boolean isAlreadyGenerated = this.codeGenerator.getGeneratedFile().isEmpty();
        if (this.isDefaultModuleActive() && !isAlreadyGenerated) {
            KSPLogger.warn$default((KSPLogger)this.logger, (String)"[Deprecation] 'defaultModule' generation is deprecated. Use KSP argument arg(\"KOIN_DEFAULT_MODULE\",\"true\") to activate default module generation.", null, (int)2, null);
        }
        if (isConfigCheckActive && isAlreadyGenerated) {
            KSPLogger.warn$default((KSPLogger)this.logger, (String)"Koin Configuration Check ...", null, (int)2, null);
            TimeSource.Monotonic.ValueTimeMark checkTime = doLogTimes ? TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()) : null;
            KoinTagMetaDataScanner metaTagScanner = new KoinTagMetaDataScanner(this.logger, resolver);
            List<KSAnnotated> invalidsMetaSymbols = metaTagScanner.findInvalidSymbols();
            if (!((Collection)invalidsMetaSymbols).isEmpty()) {
                KSPLogger.logging$default((KSPLogger)this.logger, (String)("Invalid symbols found (" + invalidsMetaSymbols.size() + "), waiting for next round"), null, (int)2, null);
                return invalidSymbols;
            }
            KoinConfigChecker checker = new KoinConfigChecker(this.logger, resolver);
            checker.verifyMetaModules(metaTagScanner.findMetaModules());
            checker.verifyMetaDefinitions(metaTagScanner.findMetaDefinitions());
            if (doLogTimes && checkTime != null) {
                TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)checkTime.unbox-impl());
                KSPLogger.warn$default((KSPLogger)this.logger, (String)("Koin Configuration Check done in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)checkTime.unbox-impl()))), null, (int)2, null);
            }
        }
        return CollectionsKt.emptyList();
    }

    private final void initComponents(Resolver resolver) {
        this.koinCodeGenerator.setResolver(resolver);
    }

    private final boolean isConfigCheckActive() {
        return Intrinsics.areEqual((Object)this.options.getOrDefault("KOIN_CONFIG_CHECK", "false"), (Object)"true");
    }

    private final boolean isKoinViewModelMPActive() {
        boolean option = Intrinsics.areEqual((Object)this.options.getOrDefault("KOIN_USE_COMPOSE_VIEWMODEL", "true"), (Object)"true");
        return option;
    }

    private final boolean isDefaultModuleActive() {
        return Intrinsics.areEqual((Object)this.options.getOrDefault("KOIN_DEFAULT_MODULE", "true"), (Object)"true");
    }

    private final boolean doLogTimes() {
        return Intrinsics.areEqual((Object)this.options.getOrDefault("KOIN_LOG_TIMES", "false"), (Object)"true");
    }
}

