/*
 * Decompiled with CFR 0.152.
 */
package org.koin.compiler.generator;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.koin.compiler.generator.ClassModuleWriter;
import org.koin.compiler.generator.DefaultModuleWriter;
import org.koin.compiler.generator.ModuleWriter;
import org.koin.compiler.metadata.KoinMetaData;
import org.koin.compiler.metadata.KoinMetaDataKt;
import org.koin.compiler.resolver.ResolverExtKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0007J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lorg/koin/compiler/generator/KoinCodeGenerator;", "", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "isViewModelMPActive", "", "<init>", "(Lcom/google/devtools/ksp/processing/CodeGenerator;Lcom/google/devtools/ksp/processing/KSPLogger;Z)V", "getCodeGenerator", "()Lcom/google/devtools/ksp/processing/CodeGenerator;", "getLogger", "()Lcom/google/devtools/ksp/processing/KSPLogger;", "()Z", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "getResolver", "()Lcom/google/devtools/ksp/processing/Resolver;", "setResolver", "(Lcom/google/devtools/ksp/processing/Resolver;)V", "generateModules", "", "moduleList", "", "Lorg/koin/compiler/metadata/KoinMetaData$Module;", "defaultModule", "generateDefaultModule", "generateDefaultFile", "generateModule", "module", "checkAlreadyGenerated", "Companion", "koin-ksp-compiler"})
@SourceDebugExtension(value={"SMAP\nKoinCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoinCodeGenerator.kt\norg/koin/compiler/generator/KoinCodeGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1863#2,2:113\n1755#2,3:115\n1567#2:118\n1598#2,4:119\n1557#2:123\n1628#2,3:124\n1567#2:127\n1598#2,4:128\n*S KotlinDebug\n*F\n+ 1 KoinCodeGenerator.kt\norg/koin/compiler/generator/KoinCodeGenerator\n*L\n43#1:113,2\n57#1:115,3\n80#1:118\n80#1:119,4\n83#1:123\n83#1:124,3\n89#1:127\n89#1:128,4\n*E\n"})
public final class KoinCodeGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeGenerator codeGenerator;
    @NotNull
    private final KSPLogger logger;
    private final boolean isViewModelMPActive;
    public Resolver resolver;
    private static KSPLogger LOGGER;

    public KoinCodeGenerator(@NotNull CodeGenerator codeGenerator, @NotNull KSPLogger logger, boolean isViewModelMPActive) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.codeGenerator = codeGenerator;
        this.logger = logger;
        this.isViewModelMPActive = isViewModelMPActive;
        LOGGER = this.logger;
    }

    @NotNull
    public final CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    @NotNull
    public final KSPLogger getLogger() {
        return this.logger;
    }

    public final boolean isViewModelMPActive() {
        return this.isViewModelMPActive;
    }

    @NotNull
    public final Resolver getResolver() {
        Resolver resolver = this.resolver;
        if (resolver != null) {
            return resolver;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"resolver");
        return null;
    }

    public final void setResolver(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"<set-?>");
        this.resolver = resolver;
    }

    public final void generateModules(@NotNull List<KoinMetaData.Module> moduleList, @NotNull KoinMetaData.Module defaultModule, boolean generateDefaultModule) {
        Intrinsics.checkNotNullParameter(moduleList, (String)"moduleList");
        Intrinsics.checkNotNullParameter((Object)defaultModule, (String)"defaultModule");
        KSPLogger.logging$default((KSPLogger)this.logger, (String)("generate " + moduleList.size() + " modules ..."), null, (int)2, null);
        Iterable $this$forEach$iv = moduleList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KoinMetaData.Module it = (KoinMetaData.Module)element$iv;
            boolean bl = false;
            this.generateModule(it);
        }
        if (!((Collection)defaultModule.getDefinitions()).isEmpty()) {
            this.generateDefaultFile(defaultModule, generateDefaultModule);
        }
    }

    private final void generateDefaultFile(KoinMetaData.Module defaultModule, boolean generateDefaultModule) {
        boolean hasDefaultDefinitions;
        block5: {
            boolean bl;
            KSPLogger.logging$default((KSPLogger)this.logger, (String)"generate default file ...", null, (int)2, null);
            this.checkAlreadyGenerated(defaultModule);
            Iterable $this$any$iv = defaultModule.getDefinitions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KoinMetaData.Definition it = (KoinMetaData.Definition)element$iv;
                    boolean bl2 = false;
                    if (!(ResolverExtKt.getResolution(this.getResolver(), it) == null)) continue;
                    bl = true;
                    break block5;
                }
                bl = hasDefaultDefinitions = false;
            }
        }
        if (Intrinsics.areEqual((Object)defaultModule.getAlreadyGenerated(), (Object)false) && hasDefaultDefinitions) {
            if (generateDefaultModule && !((Collection)defaultModule.getDefinitions()).isEmpty()) {
                KSPLogger.warn$default((KSPLogger)Companion.getLOGGER(), (String)("Generating 'defaultModule' with " + defaultModule.getDefinitions().size() + " definitions"), null, (int)2, null);
            }
            defaultModule.setCurrentDefinitionsToExternals();
            ModuleWriter.writeModule$default(new DefaultModuleWriter(this.codeGenerator, this.getResolver(), defaultModule, generateDefaultModule), this.isViewModelMPActive, null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateModule(KoinMetaData.Module module) {
        KSPLogger.logging$default((KSPLogger)this.logger, (String)("generate module " + module.getName()), null, (int)2, null);
        this.checkAlreadyGenerated(module);
        if (Intrinsics.areEqual((Object)module.getAlreadyGenerated(), (Object)false)) {
            int definitionsCount = module.getDefinitions().size();
            if (definitionsCount > 500) {
                void $this$mapIndexedTo$iv$iv;
                List $this$mapTo$iv$iv;
                Object object;
                Collection collection;
                void $this$mapIndexedTo$iv$iv2;
                int splitCount = definitionsCount / 500;
                KSPLogger.warn$default((KSPLogger)this.logger, (String)("Module '" + module.getName() + "' is exceeding 500 definitions (" + definitionsCount + " found). We need to split generation into " + (splitCount + 1) + " modules ..."), null, (int)2, null);
                Iterable $this$mapIndexed$iv = CollectionsKt.chunked((Iterable)module.getDefinitions(), (int)500);
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                    void index;
                    void list;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    List list2 = (List)item$iv$iv;
                    int n2 = n;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    object = CollectionsKt.emptyList();
                    List list3 = CollectionsKt.toMutableList((Collection)((Collection)list));
                    List list4 = new ArrayList();
                    String string = KoinMetaDataKt.camelCase(module.getPackageName()) + StringsKt.capitalize((String)module.getName()) + (int)index;
                    collection.add(KoinMetaData.Module.copy$default(module, "", string, list3, list4, null, null, (List)object, null, null, false, false, false, 4016, null));
                }
                List subModules = (List)destination$iv$iv;
                Iterable $this$map$iv = subModules;
                boolean $i$f$map22 = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo22 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void m;
                    KoinMetaData.Module module2 = (KoinMetaData.Module)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(new KoinMetaData.ModuleInclude(m.getPackageName(), m.getName(), m.isExpect(), m.isActual()));
                }
                List subModulesInclude = (List)destination$iv$iv2;
                List list = module.getIncludes();
                if (list == null) {
                    list = new ArrayList();
                }
                List $i$f$map22 = CollectionsKt.plus((Collection)list, (Iterable)subModulesInclude);
                $this$mapTo$iv$iv = new ArrayList();
                KoinMetaData.Module main = KoinMetaData.Module.copy$default(module, null, null, $this$mapTo$iv$iv, null, null, null, $i$f$map22, null, null, false, false, false, 4027, null);
                List allModules = CollectionsKt.plus((Collection)subModules, (Object)main);
                Iterable $this$mapIndexed$iv2 = allModules;
                boolean $i$f$mapIndexed2 = false;
                Iterable $i$f$mapTo22 = $this$mapIndexed$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
                boolean $i$f$mapIndexedTo2 = false;
                int index$iv$iv2 = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void m;
                    void index;
                    int n;
                    if ((n = index$iv$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    object = (KoinMetaData.Module)item$iv$iv;
                    int n3 = n;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    List generateIncludes = index == allModules.indexOf(main) ? subModulesInclude : CollectionsKt.emptyList();
                    new ClassModuleWriter(this.codeGenerator, this.getResolver(), (KoinMetaData.Module)m).writeModule(this.isViewModelMPActive, generateIncludes);
                    collection.add(Unit.INSTANCE);
                }
                List cfr_ignored_0 = (List)destination$iv$iv3;
            } else {
                ModuleWriter.writeModule$default(new ClassModuleWriter(this.codeGenerator, this.getResolver(), module), this.isViewModelMPActive, null, 2, null);
            }
        }
    }

    private final void checkAlreadyGenerated(KoinMetaData.Module module) {
        if (module.getAlreadyGenerated() == null) {
            module.setAlreadyGenerated(ResolverExtKt.getResolution(this.getResolver(), module) != null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/koin/compiler/generator/KoinCodeGenerator$Companion;", "", "<init>", "()V", "value", "Lcom/google/devtools/ksp/processing/KSPLogger;", "LOGGER", "getLOGGER", "()Lcom/google/devtools/ksp/processing/KSPLogger;", "koin-ksp-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSPLogger getLOGGER() {
            KSPLogger kSPLogger = LOGGER;
            if (kSPLogger != null) {
                return kSPLogger;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"LOGGER");
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

