/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import androidx.annotation.Nullable;
import io.intercom.android.sdk.models.BotIntro;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.models.carousel.Carousel;
import io.intercom.android.sdk.survey.model.SurveyData;

public class UpdateUserResponse
extends UsersResponse {
    private final TeamPresence teamPresence;
    private final Carousel carousel;
    private final BotIntro botIntro;
    private final SurveyData surveyData;
    @Nullable
    private final String botBehaviourId;

    UpdateUserResponse(Builder builder) {
        super(builder);
        this.teamPresence = builder.team_presence == null ? TeamPresence.NULL : builder.team_presence;
        this.carousel = builder.carousel == null ? new Carousel.Builder().build() : builder.carousel.build();
        this.botIntro = builder.bot_intro == null ? BotIntro.NULL : builder.bot_intro;
        this.surveyData = builder.survey == null ? SurveyData.Companion.getNULL() : builder.survey;
        this.botBehaviourId = builder.resolution_bot_behavior_version_id;
    }

    public TeamPresence getTeamPresence() {
        return this.teamPresence;
    }

    public Carousel getCarousel() {
        return this.carousel;
    }

    public BotIntro getBotIntro() {
        return this.botIntro;
    }

    public SurveyData getSurveyData() {
        return this.surveyData;
    }

    @Nullable
    public String getBotBehaviourId() {
        return this.botBehaviourId;
    }

    public static final class Builder
    extends UsersResponse.Builder {
        @Nullable
        TeamPresence team_presence;
        @Nullable
        Carousel.Builder carousel;
        @Nullable
        BotIntro bot_intro;
        @Nullable
        SurveyData survey;
        @Nullable
        String resolution_bot_behavior_version_id;

        @Override
        public UpdateUserResponse build() {
            return new UpdateUserResponse(this);
        }
    }
}

