/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.store;

import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.store.Store;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class UnreadConversationsReducer
implements Store.Reducer<Set<String>> {
    static final Set<String> INITIAL_STATE = Collections.emptySet();

    UnreadConversationsReducer() {
    }

    @Override
    public Set<String> reduce(Action<?> action, Set<String> currentState) {
        switch (action.type()) {
            case CONVERSATION_MARKED_AS_READ: {
                HashSet<String> newState = new HashSet<String>(currentState);
                String conversationId2 = (String)action.value();
                newState.remove(conversationId2);
                return newState;
            }
            case UNREAD_CONVERSATIONS_SUCCESS: {
                UsersResponse response = (UsersResponse)action.value();
                return new HashSet<String>(response.getUnreadConversations().getUnreadConversationIds());
            }
            case FETCH_CONVERSATION_SUCCESS: {
                HashSet<String> newState = new HashSet<String>(currentState);
                Conversation conversation = (Conversation)action.value();
                if (conversation.isRead()) {
                    newState.remove(conversation.getId());
                } else {
                    newState.add(conversation.getId());
                }
                return newState;
            }
            case HARD_RESET: {
                return INITIAL_STATE;
            }
        }
        return currentState;
    }
}

