/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import io.intercom.api.AuthorizationException;
import io.intercom.api.Company;
import io.intercom.api.CompanyCollection;
import io.intercom.api.DataResource;
import io.intercom.api.InvalidException;
import io.intercom.api.TagCollection;
import io.intercom.api.TypedData;
import io.intercom.api.User;
import io.intercom.api.UserCollection;
import java.util.HashMap;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Tag
extends TypedData {
    private static final HashMap<String, String> SENTINEL = Maps.newHashMap();
    @JsonProperty(value="type")
    private final String type = "tag";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;

    public static Tag tag(Tag tag, UserCollection users) throws InvalidException, AuthorizationException {
        TagTypedCollection tagTypedCollection = new TagTypedCollection();
        tagTypedCollection.setName(tag.getName());
        tagTypedCollection.setId(tag.getId());
        tagTypedCollection.setUsers(users.getPageItems());
        return DataResource.create(tagTypedCollection, "tags", Tag.class);
    }

    public static Tag tag(Tag tag, CompanyCollection companies) throws InvalidException, AuthorizationException {
        TagTypedCollection tagTypedCollection = new TagTypedCollection();
        tagTypedCollection.setName(tag.getName());
        tagTypedCollection.setId(tag.getId());
        tagTypedCollection.setCompanies(companies.getPageItems());
        return DataResource.create(tagTypedCollection, "tags", Tag.class);
    }

    public static Tag create(Tag tag) throws InvalidException, AuthorizationException {
        return DataResource.create(tag, "tags", Tag.class);
    }

    public static Tag update(Tag tag) throws InvalidException, AuthorizationException {
        if (tag.getId() == null) {
            throw new InvalidException("tag updates must supply an id");
        }
        return DataResource.update(tag, "tags", Tag.class);
    }

    public static Tag delete(String id) throws InvalidException, AuthorizationException {
        return DataResource.delete(id, "tags", Tag.class);
    }

    public static Tag delete(Tag tag) throws InvalidException, AuthorizationException {
        return Tag.delete(tag.getId());
    }

    public static TagCollection list() throws InvalidException, AuthorizationException {
        return DataResource.list(SENTINEL, "tags", TagCollection.class);
    }

    public String getType() {
        return "tag";
    }

    public String getId() {
        return this.id;
    }

    public Tag setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Tag setName(String name) {
        this.name = name;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        if (this.createdAt != tag.createdAt) {
            return false;
        }
        if (this.updatedAt != tag.updatedAt) {
            return false;
        }
        if (this.id != null ? !this.id.equals(tag.id) : tag.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(tag.name) : tag.name != null) {
            return false;
        }
        return "tag".equals(tag.type);
    }

    public int hashCode() {
        int result = "tag".hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        return result;
    }

    public String toString() {
        return "Tag{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "} " + super.toString();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    static class TagTypedCollection
    extends Tag {
        @JsonProperty(value="users")
        private List<User> users;
        @JsonProperty(value="companies")
        private List<Company> companies;

        TagTypedCollection() {
        }

        public List<User> getUsers() {
            return this.users;
        }

        public void setUsers(List<User> users) {
            this.users = users;
        }

        public List<Company> getCompanies() {
            return this.companies;
        }

        public void setCompanies(List<Company> companies) {
            this.companies = companies;
        }
    }
}

