/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.intercom.api.Replier;
import io.intercom.api.TypedData;

class Reply<T extends Replier>
extends TypedData {
    @JsonProperty(value="message_type")
    private final String messageType = "comment";
    @JsonProperty(value="body")
    private String body;
    @JsonProperty(value="from")
    protected T from;

    Reply() {
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.from.getReplyType();
    }

    public String getBody() {
        return this.body;
    }

    public Reply<T> setBody(String body) {
        this.body = body;
        return this;
    }

    public T getFrom() {
        return this.from;
    }

    public Reply<T> setFrom(T from) {
        this.from = from;
        return this;
    }

    public String getMessageType() {
        return "comment";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reply reply = (Reply)o;
        if (this.body != null ? !this.body.equals(reply.body) : reply.body != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(reply.from) : reply.from != null) {
            return false;
        }
        return "comment".equals(reply.messageType);
    }

    public int hashCode() {
        int result = "comment".hashCode();
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Reply{messageType='comment', body='" + this.body + '\'' + ", from=" + this.from + "} " + super.toString();
    }
}

