/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import io.intercom.api.AuthorizationException;
import io.intercom.api.ClientException;
import io.intercom.api.CompanyCollection;
import io.intercom.api.CompanyWithStringPlan;
import io.intercom.api.CustomAttribute;
import io.intercom.api.DataResource;
import io.intercom.api.HttpClient;
import io.intercom.api.InvalidException;
import io.intercom.api.RateLimitException;
import io.intercom.api.ScrollableCompanyCollection;
import io.intercom.api.SegmentCollection;
import io.intercom.api.ServerException;
import io.intercom.api.TagCollection;
import io.intercom.api.TypedData;
import io.intercom.api.UriBuilder;
import io.intercom.api.UserCollection;
import java.net.URI;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Company
extends TypedData {
    private static final Map<String, String> SENTINEL = Maps.newHashMap();
    @JsonProperty(value="type")
    private final String type = "company";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="company_id")
    private String companyID;
    @JsonProperty(value="session_count")
    private int sessionCount;
    @JsonProperty(value="monthly_spend")
    private float monthlySpend;
    @JsonProperty(value="remote_created_at")
    private long remoteCreatedAt;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty(value="plan")
    private Plan plan;
    @JsonProperty(value="user_count")
    private Integer userCount;
    @JsonIgnoreProperties(ignoreUnknown=false)
    @JsonProperty(value="custom_attributes")
    private Map<String, CustomAttribute> customAttributes = Maps.newHashMap();
    @JsonProperty(value="segments")
    private SegmentCollection segmentCollection = new SegmentCollection();
    @JsonProperty(value="tags")
    private TagCollection tagCollection = new TagCollection();
    private Boolean untag;

    public static Company find(String id) throws InvalidException, AuthorizationException {
        HttpClient resource = new HttpClient(UriBuilder.newBuilder().path("companies").path(id).build());
        return resource.get(Company.class);
    }

    public static Company find(Map<String, String> params) throws InvalidException, AuthorizationException {
        if (!params.containsKey("company_id") && !params.containsKey("name")) {
            throw new InvalidException("a company find must include a company_id or name parameter");
        }
        return DataResource.find(params, "companies", Company.class);
    }

    public static Company create(Company company) throws InvalidException, AuthorizationException {
        return Company.update(company);
    }

    public static Company update(Company company) throws InvalidException, AuthorizationException {
        CompanyWithStringPlan entity = new CompanyWithStringPlan();
        entity.setCompanyID(company.getCompanyID());
        entity.setName(company.getName());
        entity.setSessionCount(company.getSessionCount());
        entity.setMonthlySpend(company.getMonthlySpend());
        entity.setRemoteCreatedAt(company.getRemoteCreatedAt());
        if (company.getCustomAttributes() != null) {
            entity.getCustomAttributes().putAll(company.getCustomAttributes());
        }
        if (company.getPlan() != null) {
            entity.setPlan(company.getPlan().getName());
        }
        return DataResource.update(entity, "companies", Company.class);
    }

    public static CompanyCollection list(Map<String, String> params) throws InvalidException, AuthorizationException {
        return DataResource.list(params, "companies", CompanyCollection.class);
    }

    public static CompanyCollection list() throws InvalidException, AuthorizationException {
        return DataResource.list(SENTINEL, "companies", CompanyCollection.class);
    }

    public static ScrollableCompanyCollection scroll() throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.scroll(null, "companies", ScrollableCompanyCollection.class);
    }

    public static UserCollection listUsers(Map<String, String> params) throws InvalidException, AuthorizationException {
        URI usersURI;
        if (params.containsKey("company_id")) {
            usersURI = UriBuilder.newBuilder().path("companies").query("company_id", params.get("company_id")).query("type", "users").build();
        } else if (params.containsKey("id")) {
            usersURI = UriBuilder.newBuilder().path("companies").path(params.get("id")).path("users").build();
        } else {
            throw new InvalidException("a company user list query must supply a company_id or id parameter");
        }
        HttpClient resource = new HttpClient(usersURI);
        return resource.get(UserCollection.class);
    }

    public Company untag() {
        this.untag = Boolean.TRUE;
        return this;
    }

    @Override
    public String getType() {
        return "company";
    }

    public String getId() {
        return this.id;
    }

    @VisibleForTesting
    Company setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Company setName(String name) {
        this.name = name;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public String getCompanyID() {
        return this.companyID;
    }

    public Company setCompanyID(String companyID) {
        this.companyID = companyID;
        return this;
    }

    public int getSessionCount() {
        return this.sessionCount;
    }

    public long getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    public Company setRemoteCreatedAt(long remoteCreatedAt) {
        this.remoteCreatedAt = remoteCreatedAt;
        return this;
    }

    public Map<String, CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public Company setCustomAttributes(Map<String, CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
        return this;
    }

    public Company addCustomAttribute(CustomAttribute customAttribute) {
        this.customAttributes.put(customAttribute.getName(), customAttribute);
        return this;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public Company setPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public Integer getUserCount() {
        return this.userCount;
    }

    public float getMonthlySpend() {
        return this.monthlySpend;
    }

    public Company setMonthlySpend(float monthlySpend) {
        this.monthlySpend = monthlySpend;
        return this;
    }

    public SegmentCollection getSegmentCollection() {
        return this.segmentCollection;
    }

    public TagCollection getTagCollection() {
        return this.tagCollection;
    }

    boolean isUntag() {
        return this.untag == null ? false : this.untag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Company company = (Company)o;
        if (this.createdAt != company.createdAt) {
            return false;
        }
        if (Float.compare(company.monthlySpend, this.monthlySpend) != 0) {
            return false;
        }
        if (this.remoteCreatedAt != company.remoteCreatedAt) {
            return false;
        }
        if (this.sessionCount != company.sessionCount) {
            return false;
        }
        if (this.updatedAt != company.updatedAt) {
            return false;
        }
        if (this.companyID != null ? !this.companyID.equals(company.companyID) : company.companyID != null) {
            return false;
        }
        if (this.customAttributes != null ? !this.customAttributes.equals(company.customAttributes) : company.customAttributes != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(company.id) : company.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(company.name) : company.name != null) {
            return false;
        }
        if (this.plan != null ? !this.plan.equals(company.plan) : company.plan != null) {
            return false;
        }
        if (this.segmentCollection != null ? !this.segmentCollection.equals(company.segmentCollection) : company.segmentCollection != null) {
            return false;
        }
        if (this.tagCollection != null ? !this.tagCollection.equals(company.tagCollection) : company.tagCollection != null) {
            return false;
        }
        if (!"company".equals(company.type)) {
            return false;
        }
        if (this.untag != null ? !this.untag.equals(company.untag) : company.untag != null) {
            return false;
        }
        return !(this.userCount != null ? !this.userCount.equals(company.userCount) : company.userCount != null);
    }

    public int hashCode() {
        int result = "company".hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.companyID != null ? this.companyID.hashCode() : 0);
        result = 31 * result + this.sessionCount;
        result = 31 * result + (this.monthlySpend != 0.0f ? Float.floatToIntBits(this.monthlySpend) : 0);
        result = 31 * result + (int)(this.remoteCreatedAt ^ this.remoteCreatedAt >>> 32);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        result = 31 * result + (this.plan != null ? this.plan.hashCode() : 0);
        result = 31 * result + (this.userCount != null ? this.userCount.hashCode() : 0);
        result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
        result = 31 * result + (this.segmentCollection != null ? this.segmentCollection.hashCode() : 0);
        result = 31 * result + (this.tagCollection != null ? this.tagCollection.hashCode() : 0);
        result = 31 * result + (this.untag != null ? this.untag.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Company{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", companyID='" + this.companyID + '\'' + ", sessionCount=" + this.sessionCount + ", monthlySpend=" + this.monthlySpend + ", remoteCreatedAt=" + this.remoteCreatedAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", plan=" + this.plan + ", customAttributes=" + this.customAttributes + ", segmentCollection=" + this.segmentCollection + ", tagCollection=" + this.tagCollection + "} " + super.toString();
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Plan
    extends TypedData {
        @JsonProperty(value="type")
        protected String type = "plan";
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;

        public Plan() {
        }

        public Plan(String name) {
            this();
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Plan plan = (Plan)o;
            if (this.id != null ? !this.id.equals(plan.id) : plan.id != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(plan.name) : plan.name != null);
        }

        public String toString() {
            return "Plan{id='" + this.id + '\'' + ", name='" + this.name + '\'' + "} " + super.toString();
        }
    }
}

