/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import io.intercom.api.HttpConnectorSupplier;
import java.net.URI;

public class Intercom {
    private static final URI API_BASE_URI = URI.create("https://api.intercom.io/");
    private static volatile boolean useThreadLocal = false;
    private static volatile URI apiBaseURI = API_BASE_URI;
    private static final String VERSION = "2.8.2";
    public static final String USER_AGENT = "intercom-java/2.8.2";
    private static ThreadLocal<Context> threadContext = Intercom.newThreadLocalContext();
    private static final Context staticContext = new Context();
    private static volatile HttpConnectorSupplier httpConnectorSupplier = HttpConnectorSupplier.defaultSupplier;

    private static Context getContext() {
        if (useThreadLocal) {
            return threadContext.get();
        }
        return staticContext;
    }

    public static long currentTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static int getConnectionTimeout() {
        return Intercom.getContext().connectionTimeout;
    }

    public static void setConnectionTimeout(int connectionTimeout) {
        Intercom.getContext().connectionTimeout = connectionTimeout;
    }

    public static int getRequestTimeout() {
        return Intercom.getContext().requestTimeout;
    }

    public static void setRequestTimeout(int requestTimeout) {
        Intercom.getContext().requestTimeout = requestTimeout;
    }

    public static boolean isRequestUsingCaches() {
        return Intercom.getContext().requestUsingCaches;
    }

    public static void setRequestUsingCaches(boolean requestUsingCaches) {
        Intercom.getContext().requestUsingCaches = requestUsingCaches;
    }

    public static HttpConnectorSupplier getHttpConnectorSupplier() {
        return httpConnectorSupplier;
    }

    public static void setHttpConnectorSupplier(HttpConnectorSupplier supplier) {
        httpConnectorSupplier = supplier;
    }

    public static void setToken(String token) {
        Context context = Intercom.getContext();
        context.token = token;
    }

    public static URI getApiBaseURI() {
        return apiBaseURI;
    }

    public static void setApiBaseURI(URI apiBaseURI) {
        Intercom.apiBaseURI = apiBaseURI;
    }

    public static String getToken() {
        return Intercom.getContext().token;
    }

    public static boolean usesThreadLocal() {
        return useThreadLocal;
    }

    public static void setUseThreadLocal(boolean useThreadLocal) {
        Intercom.useThreadLocal = useThreadLocal;
    }

    public static void clearThreadLocalContext() {
        threadContext.remove();
    }

    public static void clearThreadLocalContexts() {
        threadContext = Intercom.newThreadLocalContext();
    }

    private static ThreadLocal<Context> newThreadLocalContext() {
        return new ThreadLocal<Context>(){

            @Override
            protected Context initialValue() {
                return new Context();
            }
        };
    }

    static class Context {
        private volatile String token;
        private volatile int connectionTimeout = 3000;
        private volatile int requestTimeout = 60000;
        private volatile boolean requestUsingCaches = false;

        Context() {
        }
    }
}

