/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.alertings;

import java.util.regex.Pattern;

public enum AlerteLevels {
    FATAL(1000000, ".*fatal.*", "#980101"),
    ERROR(100000, ".*error.*", "#d40000"),
    WARN(10000, ".*warn.*", "#fb8b00"),
    INFO(1000, ".*info.*", "#339900"),
    DEBUG(100, ".*debug.*", "#013397"),
    TRACE(10, ".*trace.*", "#666666"),
    OFF(0, "^OFF$", "#cccccf"),
    UNDEFINE(1, "#333333");

    private static final AlerteLevels[] values;
    private int level;
    private Pattern regex;
    private String color;

    private AlerteLevels(int level, String color) {
        this.level = level;
        this.regex = null;
        this.color = color;
    }

    private AlerteLevels(int level, String regex, String color) {
        this.level = level;
        this.regex = Pattern.compile(regex);
        this.color = color;
    }

    public static synchronized AlerteLevels getAlerteLevel(String level) {
        AlerteLevels result = UNDEFINE;
        if (level != null) {
            String localLevel = level.toLowerCase().trim();
            for (AlerteLevels item : values) {
                if (UNDEFINE == item) break;
                if (!item.regex.matcher(localLevel).matches()) continue;
                result = item;
                break;
            }
        }
        return result;
    }

    public static AlerteLevels getLevel(Double levelValue) {
        if (levelValue == null) {
            return UNDEFINE;
        }
        for (AlerteLevels value : values) {
            if (levelValue.intValue() < value.getLevel()) continue;
            return value;
        }
        return UNDEFINE;
    }

    public int getLevel() {
        return this.level;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public String getColor() {
        return this.color;
    }

    static {
        values = AlerteLevels.values();
    }
}

