/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.alertings;

import io.inugami.api.alertings.AlerteLevels;
import io.inugami.api.models.data.basic.JsonObject;
import java.util.ArrayList;
import java.util.List;

public final class AlertingResult
implements JsonObject {
    private static final long serialVersionUID = 7298930435253118179L;
    private String alerteName;
    private String level;
    private String url;
    private transient AlerteLevels levelType = AlerteLevels.UNDEFINE;
    private String message;
    private String subLabel;
    private long created = System.currentTimeMillis();
    private long duration = 60L;
    private transient Object data;
    private String channel = "@all";
    private boolean multiAlerts;
    private List<String> providers;

    @Override
    public JsonObject cloneObj() {
        return this.toBuilder().build();
    }

    public int getLevelNumber() {
        return this.levelType == null ? AlerteLevels.UNDEFINE.getLevel() : this.levelType.getLevel();
    }

    public static AlertingResultBuilder builder() {
        return new AlertingResultBuilder();
    }

    public AlertingResultBuilder toBuilder() {
        return new AlertingResultBuilder().alerteName(this.alerteName).level(this.level).url(this.url).levelType(this.levelType).message(this.message).subLabel(this.subLabel).created(this.created).duration(this.duration).data(this.data).channel(this.channel).multiAlerts(this.multiAlerts).providers(this.providers);
    }

    public String toString() {
        return "AlertingResult(alerteName=" + this.getAlerteName() + ", level=" + this.getLevel() + ", levelType=" + this.getLevelType() + ", message=" + this.getMessage() + ")";
    }

    public AlertingResult(String alerteName, String level, String url, AlerteLevels levelType, String message, String subLabel, long created, long duration, Object data, String channel, boolean multiAlerts, List<String> providers) {
        this.alerteName = alerteName;
        this.level = level;
        this.url = url;
        this.levelType = levelType;
        this.message = message;
        this.subLabel = subLabel;
        this.created = created;
        this.duration = duration;
        this.data = data;
        this.channel = channel;
        this.multiAlerts = multiAlerts;
        this.providers = providers;
    }

    public AlertingResult() {
    }

    public void setAlerteName(String alerteName) {
        this.alerteName = alerteName;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setLevelType(AlerteLevels levelType) {
        this.levelType = levelType;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSubLabel(String subLabel) {
        this.subLabel = subLabel;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setMultiAlerts(boolean multiAlerts) {
        this.multiAlerts = multiAlerts;
    }

    public void setProviders(List<String> providers) {
        this.providers = providers;
    }

    public String getAlerteName() {
        return this.alerteName;
    }

    public String getLevel() {
        return this.level;
    }

    public String getUrl() {
        return this.url;
    }

    public AlerteLevels getLevelType() {
        return this.levelType;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSubLabel() {
        return this.subLabel;
    }

    public long getCreated() {
        return this.created;
    }

    public long getDuration() {
        return this.duration;
    }

    public Object getData() {
        return this.data;
    }

    public String getChannel() {
        return this.channel;
    }

    public boolean isMultiAlerts() {
        return this.multiAlerts;
    }

    public List<String> getProviders() {
        return this.providers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertingResult)) {
            return false;
        }
        AlertingResult other = (AlertingResult)o;
        String this$alerteName = this.getAlerteName();
        String other$alerteName = other.getAlerteName();
        return !(this$alerteName == null ? other$alerteName != null : !this$alerteName.equals(other$alerteName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $alerteName = this.getAlerteName();
        result = result * 59 + ($alerteName == null ? 43 : $alerteName.hashCode());
        return result;
    }

    public static class AlertingResultBuilder {
        private String alerteName;
        private String level;
        private String url;
        private AlerteLevels levelType;
        private String message;
        private String subLabel;
        private long created;
        private long duration;
        private Object data;
        private String channel;
        private boolean multiAlerts;
        private List<String> providers;

        public AlertingResultBuilder addProviders(String ... values) {
            this.initProviders();
            for (String provider : values) {
                this.providers.add(provider);
            }
            return this;
        }

        private void initProviders() {
            if (this.providers == null) {
                this.providers = new ArrayList<String>();
            }
        }

        AlertingResultBuilder() {
        }

        public AlertingResultBuilder alerteName(String alerteName) {
            this.alerteName = alerteName;
            return this;
        }

        public AlertingResultBuilder level(String level) {
            this.level = level;
            return this;
        }

        public AlertingResultBuilder url(String url) {
            this.url = url;
            return this;
        }

        public AlertingResultBuilder levelType(AlerteLevels levelType) {
            this.levelType = levelType;
            return this;
        }

        public AlertingResultBuilder message(String message) {
            this.message = message;
            return this;
        }

        public AlertingResultBuilder subLabel(String subLabel) {
            this.subLabel = subLabel;
            return this;
        }

        public AlertingResultBuilder created(long created) {
            this.created = created;
            return this;
        }

        public AlertingResultBuilder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public AlertingResultBuilder data(Object data) {
            this.data = data;
            return this;
        }

        public AlertingResultBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public AlertingResultBuilder multiAlerts(boolean multiAlerts) {
            this.multiAlerts = multiAlerts;
            return this;
        }

        public AlertingResultBuilder providers(List<String> providers) {
            this.providers = providers;
            return this;
        }

        public AlertingResult build() {
            return new AlertingResult(this.alerteName, this.level, this.url, this.levelType, this.message, this.subLabel, this.created, this.duration, this.data, this.channel, this.multiAlerts, this.providers);
        }

        public String toString() {
            return "AlertingResult.AlertingResultBuilder(alerteName=" + this.alerteName + ", level=" + this.level + ", url=" + this.url + ", levelType=" + this.levelType + ", message=" + this.message + ", subLabel=" + this.subLabel + ", created=" + this.created + ", duration=" + this.duration + ", data=" + this.data + ", channel=" + this.channel + ", multiAlerts=" + this.multiAlerts + ", providers=" + this.providers + ")";
        }
    }
}

