/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.alertings;

import io.inugami.api.alertings.AlerteLevels;

public final class DynamicAlertingLevel {
    private String name;
    private AlerteLevels level;
    private double threshold;
    private int activationDelay;
    private long duration;
    private String nominal;
    private String unit;
    private String service;
    private String component;
    private boolean inverse;

    public static DynamicAlertingLevelBuilder builder() {
        return new DynamicAlertingLevelBuilder();
    }

    public DynamicAlertingLevelBuilder toBuilder() {
        return new DynamicAlertingLevelBuilder().name(this.name).level(this.level).threshold(this.threshold).activationDelay(this.activationDelay).duration(this.duration).nominal(this.nominal).unit(this.unit).service(this.service).component(this.component).inverse(this.inverse);
    }

    public String toString() {
        return "DynamicAlertingLevel(name=" + this.getName() + ", level=" + this.getLevel() + ", threshold=" + this.getThreshold() + ", activationDelay=" + this.getActivationDelay() + ", duration=" + this.getDuration() + ", nominal=" + this.getNominal() + ", unit=" + this.getUnit() + ", service=" + this.getService() + ", component=" + this.getComponent() + ", inverse=" + this.isInverse() + ")";
    }

    public DynamicAlertingLevel(String name, AlerteLevels level, double threshold, int activationDelay, long duration, String nominal, String unit, String service, String component, boolean inverse) {
        this.name = name;
        this.level = level;
        this.threshold = threshold;
        this.activationDelay = activationDelay;
        this.duration = duration;
        this.nominal = nominal;
        this.unit = unit;
        this.service = service;
        this.component = component;
        this.inverse = inverse;
    }

    public DynamicAlertingLevel() {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLevel(AlerteLevels level) {
        this.level = level;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void setActivationDelay(int activationDelay) {
        this.activationDelay = activationDelay;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setNominal(String nominal) {
        this.nominal = nominal;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public String getName() {
        return this.name;
    }

    public AlerteLevels getLevel() {
        return this.level;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public int getActivationDelay() {
        return this.activationDelay;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getNominal() {
        return this.nominal;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getService() {
        return this.service;
    }

    public String getComponent() {
        return this.component;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicAlertingLevel)) {
            return false;
        }
        DynamicAlertingLevel other = (DynamicAlertingLevel)o;
        AlerteLevels this$level = this.getLevel();
        AlerteLevels other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)((Object)this$level)).equals((Object)other$level)) {
            return false;
        }
        return Double.compare(this.getThreshold(), other.getThreshold()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AlerteLevels $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)((Object)$level)).hashCode());
        long $threshold = Double.doubleToLongBits(this.getThreshold());
        result = result * 59 + (int)($threshold >>> 32 ^ $threshold);
        return result;
    }

    public static class DynamicAlertingLevelBuilder {
        private String name;
        private AlerteLevels level;
        private double threshold;
        private int activationDelay;
        private long duration;
        private String nominal;
        private String unit;
        private String service;
        private String component;
        private boolean inverse;

        public DynamicAlertingLevelBuilder addLevel(Double value) {
            this.level = AlerteLevels.getLevel(value);
            return this;
        }

        DynamicAlertingLevelBuilder() {
        }

        public DynamicAlertingLevelBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DynamicAlertingLevelBuilder level(AlerteLevels level) {
            this.level = level;
            return this;
        }

        public DynamicAlertingLevelBuilder threshold(double threshold) {
            this.threshold = threshold;
            return this;
        }

        public DynamicAlertingLevelBuilder activationDelay(int activationDelay) {
            this.activationDelay = activationDelay;
            return this;
        }

        public DynamicAlertingLevelBuilder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public DynamicAlertingLevelBuilder nominal(String nominal) {
            this.nominal = nominal;
            return this;
        }

        public DynamicAlertingLevelBuilder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public DynamicAlertingLevelBuilder service(String service) {
            this.service = service;
            return this;
        }

        public DynamicAlertingLevelBuilder component(String component) {
            this.component = component;
            return this;
        }

        public DynamicAlertingLevelBuilder inverse(boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public DynamicAlertingLevel build() {
            return new DynamicAlertingLevel(this.name, this.level, this.threshold, this.activationDelay, this.duration, this.nominal, this.unit, this.service, this.component, this.inverse);
        }

        public String toString() {
            return "DynamicAlertingLevel.DynamicAlertingLevelBuilder(name=" + this.name + ", level=" + this.level + ", threshold=" + this.threshold + ", activationDelay=" + this.activationDelay + ", duration=" + this.duration + ", nominal=" + this.nominal + ", unit=" + this.unit + ", service=" + this.service + ", component=" + this.component + ", inverse=" + this.inverse + ")";
        }
    }
}

