/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.configurtation;

import io.inugami.api.configurtation.ConfigurationSpi;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class DefaultConfigurationSpi
implements ConfigurationSpi {
    private static final Map<String, String> CONFIGURATION = new LinkedHashMap<String, String>();

    public DefaultConfigurationSpi() {
        DefaultConfigurationSpi.loadConfiguration();
    }

    static Map<String, String> loadConfiguration() {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            CONFIGURATION.put(entry.getKey(), entry.getValue());
        }
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            CONFIGURATION.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return CONFIGURATION;
    }

    public String getProperty(String key) {
        return key == null ? null : CONFIGURATION.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String result = this.getProperty(key);
        return result == null ? defaultValue : result;
    }

    public boolean getBooleanProperty(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String result = this.getProperty(key);
        return result == null ? defaultValue : Boolean.parseBoolean(result);
    }

    public int getIntProperty(String key) {
        return this.getIntProperty(key, 0);
    }

    public int getIntProperty(String key, int defaultValue) {
        try {
            String value = this.getProperty(key);
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public long getLongProperty(String key) {
        return this.getLongProperty(key, 0L);
    }

    public long getLongProperty(String key, long defaultValue) {
        try {
            String value = this.getProperty(key);
            return value == null ? defaultValue : (long)Integer.parseInt(value);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public double getDoubleProperty(String key) {
        return this.getDoubleProperty(key, 0.0);
    }

    public double getDoubleProperty(String key, double defaultValue) {
        try {
            String value = this.getProperty(key);
            return value == null ? defaultValue : (double)Integer.parseInt(value);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }
}

